/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ObjectArray<T>
implements Collection<T> {
    private static final int DEFAULT_SIZE = 16;
    protected Object[] data;
    protected int insertionIdx;

    public ObjectArray() {
        this(16);
    }

    public ObjectArray(int size) {
        this.data = new Object[size];
    }

    private void resize() {
        Object[] t = new Object[this.data.length * 2];
        System.arraycopy(this.data, 0, t, 0, this.data.length);
        this.data = t;
    }

    @Override
    public int size() {
        return this.insertionIdx;
    }

    public T get(int idx) {
        if (idx >= 0 && idx < this.insertionIdx) {
            return (T)this.data[idx];
        }
        return null;
    }

    private void remove0(int idx) {
        Object m = this.data[--this.insertionIdx];
        this.data[this.insertionIdx] = null;
        if (idx < this.insertionIdx) {
            this.data[idx] = m;
        }
    }

    @Override
    public boolean removeIf(@Nonnull Predicate<? super T> pred) {
        boolean result = false;
        for (int i = this.insertionIdx - 1; i >= 0; --i) {
            if (!pred.test(this.data[i])) continue;
            result = true;
            this.remove0(i);
        }
        return result;
    }

    public void forEvery(@Nonnull Consumer<T> consumer) {
        for (int i = this.insertionIdx - 1; i >= 0; --i) {
            consumer.accept(this.data[i]);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.insertionIdx == 0;
    }

    private int find(@Nonnull Object o) {
        for (int i = 0; i < this.insertionIdx; ++i) {
            if (this.data[i] != o) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(@Nonnull Object o) {
        return this.find(o) != -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int idx = -1;

            @Override
            public boolean hasNext() {
                return this.idx + 1 < ObjectArray.this.insertionIdx;
            }

            @Override
            public T next() {
                return ObjectArray.this.data[++this.idx];
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.insertionIdx];
        System.arraycopy(this.data, 0, result, 0, this.insertionIdx);
        return result;
    }

    @Override
    public <T> T[] toArray(@Nonnull T[] a) {
        if (a.length < this.insertionIdx) {
            return Arrays.copyOf(this.data, this.insertionIdx, a.getClass());
        }
        System.arraycopy(this.data, 0, a, 0, this.insertionIdx);
        if (a.length > this.insertionIdx) {
            a[this.insertionIdx] = null;
        }
        return a;
    }

    @Override
    public boolean add(@Nonnull T e) {
        if (e == null) {
            return false;
        }
        if (this.data.length == this.insertionIdx) {
            this.resize();
        }
        this.data[this.insertionIdx++] = e;
        return true;
    }

    @Override
    public boolean remove(@Nonnull Object o) {
        int idx = this.find(o);
        if (idx != -1) {
            this.remove0(idx);
        }
        return idx != -1;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends T> c) {
        boolean result = false;
        for (T element : c) {
            result = result || this.add(element);
        }
        return result;
    }

    public boolean addAll(@Nonnull T[] list) {
        boolean result = false;
        for (T element : list) {
            result = result || this.add(element);
        }
        return result;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        if (this.insertionIdx == 0) {
            return;
        }
        this.data = new Object[this.data.length];
        this.insertionIdx = 0;
    }
}

