/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.effects;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.registry.EntityEffectInfo;
import org.blockartistry.lib.collections.ObjectArray;
import org.blockartistry.lib.effects.EntityEffect;
import org.blockartistry.lib.effects.EntityEffectHandler;
import org.blockartistry.lib.effects.IEntityEffectFactory;
import org.blockartistry.lib.effects.IEntityEffectFactoryFilter;
import org.blockartistry.lib.effects.IParticleHelper;
import org.blockartistry.lib.effects.ISoundHelper;

@SideOnly(value=Side.CLIENT)
public class EntityEffectLibrary {
    protected final ObjectArray<IEntityEffectFactoryFilter> filters = new ObjectArray();
    protected final ObjectArray<IEntityEffectFactory> factories = new ObjectArray();
    protected final IParticleHelper particleHelper;
    protected final ISoundHelper soundHelper;

    public EntityEffectLibrary(@Nonnull IParticleHelper ph, @Nonnull ISoundHelper sh) {
        this.particleHelper = ph;
        this.soundHelper = sh;
    }

    public void register(@Nonnull IEntityEffectFactoryFilter filter, @Nonnull IEntityEffectFactory factory) {
        this.filters.add(filter);
        this.factories.add(factory);
    }

    @Nonnull
    public Optional<EntityEffectHandler> create(@Nonnull Entity entity) {
        ArrayList<EntityEffect> effectToApply = new ArrayList<EntityEffect>();
        EntityEffectInfo eei = ClientRegistry.EFFECTS.getEffects(entity);
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!this.filters.get(i).applies(entity, eei)) continue;
            List<EntityEffect> r = this.factories.get(i).create(entity, eei);
            effectToApply.addAll(r);
        }
        EntityEffectHandler result = effectToApply.size() > 0 ? new EntityEffectHandler(entity, effectToApply, this.particleHelper, this.soundHelper) : new EntityEffectHandler.Dummy(entity);
        return Optional.of(result);
    }
}

