/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.effects;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.lib.effects.EffectStateBase;
import org.blockartistry.lib.effects.EventEffect;
import org.blockartistry.lib.effects.IEventEffectLibraryState;
import org.blockartistry.lib.effects.IParticleHelper;
import org.blockartistry.lib.effects.ISoundHelper;
import org.blockartistry.lib.sound.BasicSound;

@SideOnly(value=Side.CLIENT)
public class EventEffectLibrary
extends EffectStateBase
implements IEventEffectLibraryState {
    protected final List<EventEffect> effects = new ArrayList<EventEffect>();

    public EventEffectLibrary(@Nonnull IParticleHelper ph, @Nonnull ISoundHelper sh) {
        super(ph, sh);
    }

    public void register(@Nonnull EventEffect effect) {
        effect.setState(this);
        this.effects.add(effect);
        MinecraftForge.EVENT_BUS.register((Object)effect);
    }

    public void cleanup() {
        this.effects.forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).unregister(arg_0));
        this.effects.clear();
    }

    @Override
    public boolean isActivePlayer(@Nonnull Entity player2) {
        EntityPlayerSP ep = Minecraft.func_71410_x().field_71439_g;
        return ep != null && ep.func_145782_y() == player2.func_145782_y();
    }

    @Override
    @Nonnull
    public BasicSound<?> createSound(@Nonnull SoundEffect se, @Nonnull Entity player2) {
        if (this.isActivePlayer(player2)) {
            return se.createSound(player2, false);
        }
        return se.createSound(player2);
    }
}

