/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ITickable;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.lib.expression.DynamicVariantList;
import org.blockartistry.lib.expression.Expression;
import org.blockartistry.lib.expression.IDynamicVariant;
import org.blockartistry.lib.expression.LazyVariant;
import org.blockartistry.lib.expression.StringValue;
import org.blockartistry.lib.expression.Variant;
import org.blockartistry.lib.logging.ModLog;

public class ExpressionCache
implements ITickable {
    protected final ModLog logger;
    protected final List<DynamicVariantList> variants = new ArrayList<DynamicVariantList>();
    protected final IdentityHashMap<String, LazyVariant> cache = new IdentityHashMap();
    protected final List<String> naughtyList = new ArrayList<String>();
    protected List<IDynamicVariant<?>> cachedList;

    public ExpressionCache(@Nonnull ModLog logger) {
        this.logger = logger;
    }

    public void add(@Nonnull DynamicVariantList dvl) {
        this.variants.add(dvl);
        this.cachedList = null;
    }

    @Nonnull
    public List<String> getNaughtyList() {
        return this.naughtyList;
    }

    @Nonnull
    public List<IDynamicVariant<?>> getVariantList() {
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
            this.variants.forEach(dvl -> this.cachedList.addAll(dvl.getList()));
            Collections.sort(this.cachedList, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        }
        return this.cachedList;
    }

    public void func_73660_a() {
        this.variants.forEach(DynamicVariantList::update);
    }

    @Nonnull
    private LazyVariant compile(@Nonnull String expression) {
        LazyVariant exp = null;
        try {
            exp = this.cache.get(expression);
            if (exp == null) {
                Expression x = new Expression(expression);
                this.variants.forEach(dvl -> dvl.attach(x));
                exp = x.getProgram();
                this.cache.put(expression, exp);
            }
        }
        catch (Throwable t) {
            this.naughtyList.add(expression);
            this.cache.put(expression, new StringValue(t.getMessage()));
            this.logger.warn("Unable to compile [%s]: %s", expression, t.getMessage());
        }
        return exp;
    }

    @Nonnull
    public Variant eval(@Nonnull String script) {
        return this.compile(script.intern()).eval();
    }

    public boolean check(@Nonnull String expression) {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return true;
        }
        return this.eval(expression).asBoolean();
    }
}

