/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.expression;

import javax.annotation.Nonnull;
import org.blockartistry.lib.expression.Variant;

public class StringValue
extends Variant {
    protected String value;

    public StringValue() {
        this.value = "";
    }

    public StringValue(@Nonnull String v) {
        this.value = v;
    }

    public StringValue(@Nonnull String name, @Nonnull String value) {
        super(name);
        this.value = value;
    }

    @Override
    public float asNumber() {
        return Float.parseFloat(this.value);
    }

    @Override
    @Nonnull
    public String asString() {
        return this.value;
    }

    @Override
    public boolean asBoolean() {
        return !"FALSE".equalsIgnoreCase(this.value);
    }

    @Override
    public int compareTo(@Nonnull Variant variant) {
        return this.value.compareTo(variant.asString());
    }

    @Override
    @Nonnull
    public Variant add(@Nonnull Variant term) {
        return new StringValue(this.value.concat(term.asString()));
    }
}

