/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.gfx.shaders;

import java.nio.FloatBuffer;
import net.minecraft.client.renderer.GLAllocation;
import org.blockartistry.lib.gfx.shaders.ShaderException;
import org.blockartistry.lib.gfx.shaders.ShaderProgram;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class ShaderUtils {
    private static final FloatBuffer SCRATCH = GLAllocation.func_74529_h((int)16);

    private ShaderUtils() {
    }

    public static void setModelViewMatrix(String name, ShaderProgram program) throws ShaderException {
        GL11.glGetFloat((int)2982, (FloatBuffer)SCRATCH);
        program.setMatrix4(name, SCRATCH);
        SCRATCH.clear();
    }

    public static void setProjectionMatrix(String name, ShaderProgram program) throws ShaderException {
        GL11.glGetFloat((int)2983, (FloatBuffer)SCRATCH);
        program.setMatrix4(name, SCRATCH);
        SCRATCH.clear();
    }

    public static void setMVPMatrix(String name, ShaderProgram program) throws ShaderException {
        Matrix4f mv = new Matrix4f();
        GL11.glGetFloat((int)2982, (FloatBuffer)SCRATCH);
        mv.load(SCRATCH);
        SCRATCH.clear();
        Matrix4f p = new Matrix4f();
        GL11.glGetFloat((int)2983, (FloatBuffer)SCRATCH);
        p.load(SCRATCH);
        SCRATCH.clear();
        Matrix4f mvp = new Matrix4f();
        Matrix4f.mul((Matrix4f)p, (Matrix4f)mv, (Matrix4f)mvp);
        mvp.store(SCRATCH);
        SCRATCH.clear();
        program.setMatrix4(name, SCRATCH);
    }
}

