/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.gui;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.lib.Localization;

@SideOnly(value=Side.CLIENT)
public class GuiTooltip {
    protected final ITooltipRenderer renderer;
    protected final HoverChecker checker;
    protected final List<String> tooltip;

    public GuiTooltip(@Nonnull ITooltipRenderer renderer, @Nonnull GuiButton button, @Nonnull String tipText) {
        this(renderer, button, tipText, 200);
    }

    public GuiTooltip(@Nonnull ITooltipRenderer renderer, @Nonnull GuiButton button, @Nonnull String tipText, int width) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        this.renderer = renderer;
        this.checker = new HoverChecker(button, 800);
        this.tooltip = this.generateTooltip(font, tipText, width);
    }

    private List<String> generateTooltip(@Nonnull FontRenderer font, @Nonnull String langKey, int width) {
        String t = Localization.format(langKey, new Object[0]);
        return font.func_78271_c(t, width);
    }

    public boolean handle(int mouseX, int mouseY) {
        if (this.checker.checkHover(mouseX, mouseY)) {
            this.renderer.drawTooltip(mouseX, mouseY, this.tooltip);
            return true;
        }
        return false;
    }

    public static interface ITooltipRenderer {
        public void drawTooltip(int var1, int var2, @Nonnull List<String> var3);
    }
}

