/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.lib.gui.GuiUtils;
import org.blockartistry.lib.gui.Panel;

@SideOnly(value=Side.CLIENT)
public class TextPanel
extends Panel<TextPanel> {
    private final FontRenderer font;
    private List<String> text;

    public TextPanel() {
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.text = ImmutableList.of();
    }

    @Nonnull
    public TextPanel setText(@Nonnull List<String> text) {
        this.text = text;
        this.setHeight((text.size() + 1) * this.font.field_78288_b);
        int w = 0;
        for (String s : text) {
            w = Math.max(this.font.func_78256_a(s), w);
        }
        this.setWidth(w += this.font.field_78288_b);
        return this;
    }

    @Nonnull
    public TextPanel resetText() {
        this.text = ImmutableList.of();
        return this;
    }

    public boolean hasText() {
        return !this.text.isEmpty();
    }

    @Override
    public void render(int locX, int locY, @Nonnull Panel.Reference ref) {
        int posY;
        if (this.text.isEmpty()) {
            return;
        }
        switch (ref) {
            case CENTER: {
                posY = locY - this.getCenterY();
                break;
            }
            case TOP_CENTER: {
                posY = locY;
                break;
            }
            default: {
                posY = locY;
            }
        }
        super.render(locX, locY, ref);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        GlStateManager.func_179147_l();
        int textRGB = this.getForegroundColor().rgbWithAlpha(this.alpha);
        int drawX = ref == Panel.Reference.CENTER || ref == Panel.Reference.TOP_CENTER ? locX : locX + this.getCenterX();
        int drawY = posY + (this.font.field_78288_b + 1) / 2;
        for (int i = 0; i < this.text.size(); ++i) {
            GuiUtils.drawCenteredString(this.font, this.text.get(i), drawX, drawY, textRGB);
            drawY += this.font.field_78288_b;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

