/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.math;

import javax.annotation.Nonnull;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;

public class MathStuff {
    private static final int SIN_BITS = 12;
    private static final int SIN_MASK = 4095;
    private static final int SIN_COUNT = 4096;
    private static final float RAD_FULL = (float)Math.PI * 2;
    private static final float RAD_TO_INDEX = 651.8986f;
    private static final float DEG_FULL = 360.0f;
    private static final float DEG_TO_INDEX = 11.377778f;
    private static final float COS_TO_SIN = 1.5707964f;
    private static final float[] SIN_TABLE;
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    private static final int ATAN2_DIM;
    private static final float ATAN2_DIM_MINUS_1;
    private static final float[] ATAN2_TABLE;
    private static final float RAD_TO_DEG = 57.29578f;
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float PI_F = (float)Math.PI;
    public static final float E_F = (float)Math.E;

    public static final float sin(float rad) {
        return SIN_TABLE[(int)(rad * 651.8986f) & 0xFFF];
    }

    public static final float cos(float rad) {
        return SIN_TABLE[(int)((rad + 1.5707964f) * 651.8986f) & 0xFFF];
    }

    public static final float tan(float rad) {
        return MathStuff.sin(rad) / MathStuff.cos(rad);
    }

    public static final double sin(double rad) {
        float tmp = (float)rad;
        return SIN_TABLE[(int)(tmp * 651.8986f) & 0xFFF];
    }

    public static final double cos(double rad) {
        float tmp = (float)rad;
        return SIN_TABLE[(int)((tmp + 1.5707964f) * 651.8986f) & 0xFFF];
    }

    public static final double tan(double rad) {
        return MathStuff.tan((float)rad);
    }

    public static final float atan2(float y, float x) {
        float add;
        float mul;
        if (x < 0.0f) {
            if (y < 0.0f) {
                x = -x;
                y = -y;
                mul = 1.0f;
            } else {
                x = -x;
                mul = -1.0f;
            }
            add = (float)(-Math.PI);
        } else {
            if (y < 0.0f) {
                y = -y;
                mul = -1.0f;
            } else {
                mul = 1.0f;
            }
            add = 0.0f;
        }
        float invDiv = ATAN2_DIM_MINUS_1 / (x < y ? y : x);
        int xi = (int)(x * invDiv);
        int yi = (int)(y * invDiv);
        return (ATAN2_TABLE[yi * ATAN2_DIM + xi] + add) * mul;
    }

    public static final double atan2(double y, double x) {
        float tmp1 = (float)y;
        float tmp2 = (float)x;
        return MathStuff.atan2(tmp1, tmp2);
    }

    public static final float toRadians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static final float toDegrees(float radians) {
        return radians * 57.29578f;
    }

    public static float wrapDegrees(float value) {
        if ((value %= 360.0f) >= 180.0f) {
            value -= 360.0f;
        }
        if (value < -180.0f) {
            value += 360.0f;
        }
        return value;
    }

    public static double wrapDegrees(double value) {
        if ((value %= 360.0) >= 180.0) {
            value -= 360.0;
        }
        if (value < -180.0) {
            value += 360.0;
        }
        return value;
    }

    public static final float abs(float val) {
        return val < 0.0f ? -val : val;
    }

    public static final double abs(double val) {
        return val < 0.0 ? -val : val;
    }

    public static final long abs(long val) {
        return val < 1L ? -val : val;
    }

    public static final int abs(int val) {
        return val < 1 ? -val : val;
    }

    public static float sqrt(float value) {
        return (float)Math.sqrt(value);
    }

    public static double sqrt(double value) {
        return (float)Math.sqrt(value);
    }

    public static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static int floor(float value) {
        int i = (int)value;
        return value < (float)i ? i - 1 : i;
    }

    public static float clamp(float num, float min, float max) {
        return num < min ? min : (num > max ? max : num);
    }

    public static double clamp(double num, double min, double max) {
        return num < min ? min : (num > max ? max : num);
    }

    public static int clamp(int num, int min, int max) {
        return num < min ? min : (num > max ? max : num);
    }

    public static Vec2f rotateScale(@Nonnull Vec2f coord, float radians, float scale) {
        float f = MathStuff.cos(radians);
        float f1 = MathStuff.sin(radians);
        float d0 = coord.field_189982_i * f + coord.field_189983_j * f1;
        float d1 = coord.field_189983_j * f - coord.field_189982_i * f1;
        return new Vec2f(d0 * scale, d1 * scale);
    }

    public static Vec2f rotate(@Nonnull Vec2f coord, float radians) {
        return MathStuff.rotateScale(coord, radians, 1.0f);
    }

    public static final Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathStuff.cos(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float f1 = MathStuff.sin(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float f2 = -MathStuff.cos(-pitch * ((float)Math.PI / 180));
        float f3 = MathStuff.sin(-pitch * ((float)Math.PI / 180));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    static {
        int i;
        SIN_TABLE = new float[4096];
        ATAN2_DIM = (int)Math.sqrt(16384.0);
        ATAN2_DIM_MINUS_1 = ATAN2_DIM - 1;
        ATAN2_TABLE = new float[16384];
        for (i = 0; i < 4096; ++i) {
            MathStuff.SIN_TABLE[i] = (float)Math.sin(((float)i + 0.5f) / 4096.0f * ((float)Math.PI * 2));
        }
        for (i = 0; i < 360; i += 90) {
            MathStuff.SIN_TABLE[(int)((float)i * 11.377778f) & 0xFFF] = (float)Math.sin((double)i * Math.PI / 180.0);
        }
        for (i = 0; i < ATAN2_DIM; ++i) {
            for (int j = 0; j < ATAN2_DIM; ++j) {
                float x0 = (float)i / (float)ATAN2_DIM;
                float y0 = (float)j / (float)ATAN2_DIM;
                MathStuff.ATAN2_TABLE[j * MathStuff.ATAN2_DIM + i] = (float)Math.atan2(y0, x0);
            }
        }
    }
}

