/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.scanner;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.blockartistry.lib.BlockPosHelper;

public class Cuboid {
    protected final BlockPos[] vertices = new BlockPos[8];
    protected final int volume;
    protected final BlockPos minPoint;
    protected final BlockPos maxPoint;

    public Cuboid(@Nonnull BlockPos[] points) {
        this(points[0], points[1]);
    }

    public Cuboid(@Nonnull BlockPos vx1, @Nonnull BlockPos vx2) {
        this.minPoint = BlockPosHelper.createMinPoint(vx1, vx2);
        this.maxPoint = BlockPosHelper.createMaxPoint(vx1, vx2);
        BlockPos t = this.maxPoint.func_177973_b((Vec3i)this.minPoint);
        this.volume = t.func_177958_n() * t.func_177956_o() * t.func_177952_p();
        this.vertices[0] = this.minPoint;
        this.vertices[1] = this.maxPoint;
        this.vertices[2] = new BlockPos(this.minPoint.func_177958_n(), this.maxPoint.func_177956_o(), this.maxPoint.func_177952_p());
        this.vertices[3] = new BlockPos(this.maxPoint.func_177958_n(), this.minPoint.func_177956_o(), this.minPoint.func_177952_p());
        this.vertices[4] = new BlockPos(this.maxPoint.func_177958_n(), this.minPoint.func_177956_o(), this.maxPoint.func_177952_p());
        this.vertices[5] = new BlockPos(this.minPoint.func_177958_n(), this.minPoint.func_177956_o(), this.maxPoint.func_177952_p());
        this.vertices[6] = new BlockPos(this.minPoint.func_177958_n(), this.maxPoint.func_177956_o(), this.minPoint.func_177952_p());
        this.vertices[7] = new BlockPos(this.maxPoint.func_177958_n(), this.maxPoint.func_177956_o(), this.minPoint.func_177952_p());
    }

    public boolean contains(@Nonnull BlockPos p) {
        return BlockPosHelper.contains(p, this.minPoint, this.maxPoint);
    }

    @Nonnull
    public BlockPos maximum() {
        return this.maxPoint;
    }

    @Nonnull
    public BlockPos minimum() {
        return this.minPoint;
    }

    public long volume() {
        return this.volume;
    }

    @Nullable
    public Cuboid intersection(@Nonnull Cuboid o) {
        BlockPos vx1 = null;
        for (BlockPos vx : this.vertices) {
            if (!o.contains(vx)) continue;
            vx1 = vx;
            break;
        }
        if (vx1 == null) {
            return null;
        }
        BlockPos vx2 = null;
        for (BlockPos vx : o.vertices) {
            if (!this.contains(vx) || !BlockPosHelper.canFormCuboid(vx, vx1)) continue;
            vx2 = vx;
            break;
        }
        return vx2 == null ? null : new Cuboid(vx1, vx2);
    }
}

