/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.scanner;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import org.blockartistry.lib.scanner.ScanLocus;
import org.blockartistry.lib.scanner.Scanner;

public abstract class RandomScanner
extends Scanner {
    private int playerX;
    private int playerY;
    private int playerZ;

    public RandomScanner(@Nonnull ScanLocus locus, @Nonnull String name, int range) {
        super(locus, name, range);
    }

    public RandomScanner(@Nonnull ScanLocus locus, @Nonnull String name, int range, int blocksPerTick) {
        super(locus, name, range, blocksPerTick);
    }

    private static int randomRange(int range, Random rand) {
        return rand.nextInt(range) - rand.nextInt(range);
    }

    @Override
    public void preScan() {
        BlockPos pos = this.locus.getCenter();
        this.playerX = pos.func_177958_n();
        this.playerY = pos.func_177956_o();
        this.playerZ = pos.func_177952_p();
    }

    @Override
    @Nonnull
    protected BlockPos nextPos(@Nonnull BlockPos.MutableBlockPos workingPos, @Nonnull Random rand) {
        return workingPos.func_181079_c(this.playerX + RandomScanner.randomRange(this.xRange, rand), this.playerY + RandomScanner.randomRange(this.yRange, rand), this.playerZ + RandomScanner.randomRange(this.zRange, rand));
    }
}

