/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.scanner;

import java.util.Random;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import org.blockartistry.lib.BlockStateProvider;
import org.blockartistry.lib.logging.ModLog;
import org.blockartistry.lib.random.XorShiftRandom;
import org.blockartistry.lib.scanner.ScanLocus;

public abstract class Scanner
implements ITickable,
Callable<Void> {
    private static final int MAX_BLOCKS_TICK = 3000;
    protected static final IBlockState AIR_BLOCK = Blocks.field_150350_a.func_176223_P();
    protected final String name;
    protected final int xRange;
    protected final int yRange;
    protected final int zRange;
    protected final int xSize;
    protected final int ySize;
    protected final int zSize;
    protected final int blocksPerTick;
    protected final int volume;
    protected final ScanLocus locus;
    protected final Random random = new XorShiftRandom();
    protected final BlockPos.MutableBlockPos workingPos = new BlockPos.MutableBlockPos();
    protected final BlockStateProvider blockProvider = new BlockStateProvider();
    protected ModLog log = ModLog.NULL_LOGGER;

    public Scanner(@Nonnull ScanLocus locus, @Nonnull String name, int range) {
        this(locus, name, range, 0);
    }

    public Scanner(@Nonnull ScanLocus locus, @Nonnull String name, int range, int blocksPerTick) {
        this(locus, name, range, range, range, blocksPerTick);
    }

    public Scanner(@Nonnull ScanLocus locus, @Nonnull String name, int xRange, int yRange, int zRange) {
        this(locus, name, xRange, yRange, zRange, 0);
    }

    public Scanner(@Nonnull ScanLocus locus, @Nonnull String name, int xRange, int yRange, int zRange, int blocksPerTick) {
        this.name = name;
        this.xRange = xRange;
        this.yRange = yRange;
        this.zRange = zRange;
        this.xSize = xRange * 2;
        this.ySize = yRange * 2;
        this.zSize = zRange * 2;
        this.volume = this.xSize * this.ySize * this.zSize;
        this.blocksPerTick = blocksPerTick == 0 ? Math.min(this.volume / 20, 3000) : Math.min(blocksPerTick, 3000);
        this.locus = locus;
    }

    public void setLogger(@Nonnull ModLog log) {
        this.log = log;
    }

    public int getVolume() {
        return this.volume;
    }

    public abstract void blockScan(@Nonnull IBlockState var1, @Nonnull BlockPos var2, @Nonnull Random var3);

    protected boolean interestingBlock(IBlockState state) {
        return state != AIR_BLOCK;
    }

    @Override
    public Void call() {
        this.func_73660_a();
        return null;
    }

    public void preScan() {
    }

    public void postScan() {
    }

    public void func_73660_a() {
        BlockPos pos;
        this.blockProvider.setWorld(this.locus.getWorld());
        this.preScan();
        for (int count = 0; count < this.blocksPerTick && (pos = this.nextPos(this.workingPos, this.random)) != null; ++count) {
            IBlockState state = this.blockProvider.getBlockState(pos);
            if (!this.interestingBlock(state)) continue;
            this.blockScan(state, pos, this.random);
        }
        this.postScan();
    }

    @Nullable
    protected abstract BlockPos nextPos(@Nonnull BlockPos.MutableBlockPos var1, @Nonnull Random var2);
}

