/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.sound;

import com.google.common.base.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.client.sound.SoundState;
import org.blockartistry.lib.compat.ModEnvironment;
import org.blockartistry.lib.random.XorShiftRandom;
import org.blockartistry.lib.sound.SoundUtils;

@SideOnly(value=Side.CLIENT)
public class BasicSound<T extends BasicSound<?>>
extends PositionedSound
implements INBTSerializable<NBTTagCompound> {
    protected static final float ATTENUATION_OFFSET = 32.0f;
    public static final ISoundScale DEFAULT_SCALE = () -> 1.0f;
    protected final Random RANDOM = XorShiftRandom.current();
    protected final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    protected String id = "";
    protected float volumeThrottle = 1.0f;
    protected ISoundScale volumeScale;
    protected boolean route;
    protected SoundState state = SoundState.NONE;

    public BasicSound(@Nonnull SoundEvent event, @Nonnull SoundCategory cat) {
        this(event.func_187503_a(), cat);
    }

    public BasicSound(@Nonnull ResourceLocation soundResource, @Nonnull SoundCategory cat) {
        super(soundResource, cat);
        this.volumeScale = DEFAULT_SCALE;
        this.field_147662_b = 1.0f;
        this.field_147663_c = 1.0f;
        this.setPosition(0.0f, 0.0f, 0.0f);
        this.field_147659_g = false;
        this.field_147665_h = 0;
        this.field_147666_i = ISound.AttenuationType.LINEAR;
        this.route = false;
        this.field_184367_a = SoundHandler.field_147700_a;
    }

    public SoundState getState() {
        return this.state;
    }

    public T setState(@Nonnull SoundState state) {
        this.state = state;
        return (T)((Object)this);
    }

    public boolean shouldRoute() {
        return this.route;
    }

    public T setRoutable(boolean flag) {
        this.route = flag;
        return (T)((Object)this);
    }

    public T setId(@Nonnull String id) {
        this.id = id;
        return (T)((Object)this);
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public T setVolume(float v) {
        this.field_147662_b = v;
        return (T)((Object)this);
    }

    public T setPitch(float p) {
        this.field_147663_c = p;
        return (T)((Object)this);
    }

    public T setPosition(float x, float y, float z) {
        this.field_147660_d = x;
        this.field_147661_e = y;
        this.field_147658_f = z;
        this.pos.func_189532_c((double)x, (double)y, (double)z);
        return (T)((Object)this);
    }

    public T setPosition(@Nonnull Entity entity) {
        Vec3d point = entity.func_174813_aQ().func_189972_c();
        return this.setPosition(point);
    }

    public T setPosition(@Nonnull Vec3i pos) {
        return this.setPosition((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
    }

    public T setPosition(@Nonnull Vec3d pos) {
        return this.setPosition((float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c);
    }

    public float func_147654_h() {
        float y = super.func_147654_h();
        return this.func_147656_j() == ISound.AttenuationType.NONE ? y + 32.0f : y;
    }

    public T setAttenuationType(@Nonnull ISound.AttenuationType type) {
        this.field_147666_i = type;
        return (T)((Object)this);
    }

    public T setRepeat(boolean flag) {
        this.field_147659_g = flag;
        return (T)((Object)this);
    }

    public T setRepeatDelay(int delay) {
        this.field_147665_h = delay;
        return (T)((Object)this);
    }

    public T setVolumeScale(@Nonnull ISoundScale scale) {
        this.volumeScale = scale;
        return (T)((Object)this);
    }

    public T setVolumeThrottle(float throttle) {
        this.volumeThrottle = throttle;
        return (T)((Object)this);
    }

    public float func_147653_e() {
        return super.func_147653_e() * this.volumeScale.getScale() * this.volumeThrottle;
    }

    public void fade() {
    }

    public void unfade() {
    }

    public boolean isFading() {
        return false;
    }

    public boolean isDonePlaying() {
        return false;
    }

    public boolean canSoundBeHeard(@Nonnull BlockPos soundPos) {
        return this.func_147656_j() == ISound.AttenuationType.NONE ? true : SoundUtils.canBeHeard((BlockPos)this.pos, soundPos, this.func_147653_e());
    }

    public Vec3d getLocusPosition() {
        return new Vec3d((double)this.field_147660_d, (double)this.field_147661_e, (double)this.field_147658_f);
    }

    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("s", this.field_147664_a.toString());
        nbt.func_74778_a("c", this.field_184368_b.func_187948_a());
        nbt.func_74776_a("v", this.field_147662_b);
        nbt.func_74776_a("p", this.field_147663_c);
        nbt.func_74776_a("x", this.field_147660_d);
        nbt.func_74776_a("y", this.field_147661_e);
        nbt.func_74776_a("z", this.field_147658_f);
        return nbt;
    }

    public void deserializeNBT(@Nonnull NBTTagCompound nbt) {
        String cat = nbt.func_74779_i("c");
        this.field_184368_b = StringUtils.isEmpty((CharSequence)cat) ? SoundCategory.PLAYERS : SoundCategory.func_187950_a((String)cat);
        this.field_147664_a = new ResourceLocation(nbt.func_74779_i("s"));
        this.field_147662_b = nbt.func_74760_g("v");
        this.field_147663_c = nbt.func_74760_g("p");
        this.field_147660_d = nbt.func_74760_g("x");
        this.field_147661_e = nbt.func_74760_g("y");
        this.field_147658_f = nbt.func_74760_g("z");
        this.pos.func_189532_c((double)this.field_147660_d, (double)this.field_147661_e, (double)this.field_147658_f);
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).addValue((Object)this.field_147664_a.toString()).addValue((Object)this.field_184368_b.toString()).add("state", (Object)this.getState()).add("v", this.func_147653_e()).add("p", this.func_147655_f()).add("s", this.volumeScale.getScale()).addValue((Object)this.func_147656_j()).add("x", this.func_147649_g()).add("y", this.func_147654_h()).add("z", this.func_147651_i()).toString();
    }

    public static ISound.AttenuationType noAttenuation() {
        return ModEnvironment.SoundPhysics.isLoaded() ? ISound.AttenuationType.LINEAR : ISound.AttenuationType.NONE;
    }

    public static class NBT {
        public static final String SOUND_EVENT = "s";
        public static final String SOUND_CATEGORY = "c";
        public static final String VOLUME = "v";
        public static final String PITCH = "p";
        public static final String X_COORD = "x";
        public static final String Y_COORD = "y";
        public static final String Z_COORD = "z";
    }

    @FunctionalInterface
    public static interface ISoundScale {
        public float getScale();
    }
}

