/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.sound;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import org.blockartistry.lib.sound.SoundMetadataConfig;

public final class SoundConfigProcessor
implements AutoCloseable {
    private static final ParameterizedType TYPE = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class, SoundMetadataConfig.class};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    private final InputStream stream;

    public SoundConfigProcessor(@Nonnull ResourceLocation soundConfig) {
        String asset = String.format("/assets/%s/%s", soundConfig.func_110624_b(), soundConfig.func_110623_a());
        this.stream = SoundConfigProcessor.class.getResourceAsStream(asset);
    }

    public void forEach(@Nonnull ICallback callback) {
        Map sounds = (Map)new Gson().fromJson((Reader)new InputStreamReader(this.stream), (Type)TYPE);
        for (Map.Entry e : sounds.entrySet()) {
            callback.onEntry((String)e.getKey(), (SoundMetadataConfig)e.getValue());
        }
    }

    @Override
    public void close() throws Exception {
        if (this.stream != null) {
            this.stream.close();
        }
    }

    public static interface ICallback {
        public void onEntry(@Nonnull String var1, @Nonnull SoundMetadataConfig var2);
    }
}

