/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.sound;

import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import paulscode.sound.SoundSystemConfig;

public final class SoundUtils {
    private static final float DROPOFF = 256.0f;

    private SoundUtils() {
    }

    public static boolean canBeHeard(@Nonnull BlockPos pos1, @Nonnull BlockPos pos2) {
        return SoundUtils.canBeHeard(pos1, pos2, 1.0f);
    }

    public static boolean canBeHeard(@Nonnull EntityLivingBase entity, @Nonnull BlockPos pos, float volume) {
        return SoundUtils.canBeHeard(entity.func_180425_c(), pos, volume);
    }

    public static boolean canBeHeard(@Nonnull EntityLivingBase entity, @Nonnull BlockPos pos) {
        return SoundUtils.canBeHeard(entity.func_180425_c(), pos, 1.0f);
    }

    public static boolean canBeHeard(@Nonnull BlockPos pos1, @Nonnull BlockPos pos2, float volume) {
        double distanceSq;
        if (volume <= 0.0f || SoundSystemConfig.getMasterGain() <= 0.0f) {
            return false;
        }
        float dropoff = 256.0f;
        if (volume > 1.0f) {
            dropoff *= volume * volume;
        }
        return (distanceSq = pos1.func_177951_i((Vec3i)pos2)) <= (double)dropoff;
    }
}

