/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.tiles.TileBanner;
import noppes.npcs.blocks.tiles.TileColorable;
import noppes.npcs.client.renderer.ITileRenderer;

public class BlockBanner
extends BlockContainer
implements ITileRenderer {
    public static final AxisAlignedBB AABB1 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
    public static final AxisAlignedBB AABB2 = new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)5);
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    private TileColorable renderTile;

    public BlockBanner() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileBanner tile;
        if (item == null) {
            return false;
        }
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            pos = pos.func_177977_b();
        }
        if (!(tile = (TileBanner)par1World.func_175625_s(pos)).canEdit()) {
            return true;
        }
        if (item.func_77973_b() != Items.field_151100_aR) {
            return false;
        }
        int color = EnumDyeColor.func_176764_b((int)item.func_77952_i()).func_176767_b();
        if (tile.color != color) {
            NoppesUtilServer.consumeItemStack(1, player);
            tile.color = color;
            tile.func_70296_d();
            par1World.func_184138_a(pos, state, state, 3);
        }
        return true;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
        par3List.add(new ItemStack(par1, 1, 4));
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE);
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE) + ((Boolean)state.func_177229_b((IProperty)TOP) != false ? 7 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(meta % 7)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(meta >= 7));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DAMAGE, TOP});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        try {
            if (((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)TOP)).booleanValue()) {
                return AABB2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return AABB1;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (!world.func_175623_d(pos.func_177984_a())) {
            world.func_175698_g(pos);
        } else {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())), 2);
            world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())), 2);
            int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            TileBanner tile = (TileBanner)world.func_175625_s(pos);
            tile.rotation = l %= 4;
            tile.color = 15 - stack.func_77952_i();
            tile.time = System.currentTimeMillis();
            if (entity instanceof EntityPlayer && world.field_72995_K) {
                ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("availability.editIcon", new Object[0]));
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        if (var2 < 7) {
            return new TileBanner();
        }
        return null;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177977_b());
        } else if (!((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177984_a());
        }
    }

    @Override
    public TileColorable getTile() {
        if (this.renderTile == null) {
            this.renderTile = (TileColorable)this.func_149915_a(null, 0);
        }
        return this.renderTile;
    }
}

