/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseBlockUtils {
    public static String getNameForBlock(Block block) {
        return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
    }

    public static boolean blockIsGettingExternallyPowered(World world, BlockPos blockPos) {
        for (EnumFacing enumFacing : BaseUtils.facings) {
            if (!BaseBlockUtils.isPoweringSide(world, blockPos.func_177972_a(enumFacing), enumFacing)) continue;
            return true;
        }
        return false;
    }

    static boolean isPoweringSide(World world, BlockPos blockPos, EnumFacing enumFacing) {
        IBlockState iBlockState = world.func_180495_p(blockPos);
        Block block = iBlockState.func_177230_c();
        if (block.func_180656_a(iBlockState, (IBlockAccess)world, blockPos, enumFacing) > 0) {
            return true;
        }
        if (block.shouldCheckWeakPower(iBlockState, (IBlockAccess)world, blockPos, enumFacing)) {
            for (EnumFacing enumFacing2 : BaseUtils.facings) {
                if (enumFacing2 == enumFacing.func_176734_d() || world.func_175627_a(blockPos.func_177972_a(enumFacing2), enumFacing2) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static IBlockState getBlockStateFromItemStack(ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        int n = 0;
        if (itemStack.func_77973_b().func_77614_k()) {
            n = itemStack.func_77952_i() & 0xF;
        }
        return block.func_176203_a(n);
    }

    public static IBlockState getBlockStateFromMeta(Block block, int n) {
        return block.func_176203_a(n);
    }

    public static int getMetaFromBlockState(IBlockState iBlockState) {
        return iBlockState.func_177230_c().func_176201_c(iBlockState);
    }

    public static Block getWorldBlock(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return iBlockAccess.func_180495_p(blockPos).func_177230_c();
    }

    public static IBlockState getWorldBlockState(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return iBlockAccess.func_180495_p(blockPos);
    }

    public static void setWorldBlockState(World world, BlockPos blockPos, IBlockState iBlockState) {
        world.func_180501_a(blockPos, iBlockState, 3);
    }

    public static void notifyWorldNeighborsOfStateChange(World world, BlockPos blockPos, Block block) {
        world.func_175685_c(blockPos, block);
    }

    public static TileEntity getWorldTileEntity(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return iBlockAccess.func_175625_s(blockPos);
    }

    public static World getTileEntityWorld(TileEntity tileEntity) {
        return tileEntity.func_145831_w();
    }

    public static BlockPos getTileEntityPos(TileEntity tileEntity) {
        return tileEntity.func_174877_v();
    }

    public static boolean blockCanRenderInLayer(Block block, BlockRenderLayer blockRenderLayer) {
        return block.canRenderInLayer(blockRenderLayer);
    }

    public static ItemStack blockStackWithState(IBlockState iBlockState, int n) {
        Block block = iBlockState.func_177230_c();
        int n2 = block.func_176201_c(iBlockState);
        return new ItemStack(block, n, n2);
    }

    public static BlockPos readBlockPos(DataInput dataInput) {
        try {
            int n = dataInput.readInt();
            int n2 = dataInput.readInt();
            int n3 = dataInput.readInt();
            return new BlockPos(n, n2, n3);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void writeBlockPos(DataOutput dataOutput, BlockPos blockPos) {
        try {
            dataOutput.writeInt(blockPos.func_177958_n());
            dataOutput.writeInt(blockPos.func_177956_o());
            dataOutput.writeInt(blockPos.func_177952_p());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void markBlockForUpdate(World world, BlockPos blockPos) {
        world.func_175704_b(blockPos, blockPos);
        if (!world.field_72995_K) {
            IBlockState iBlockState = world.func_180495_p(blockPos);
            world.func_184138_a(blockPos, iBlockState, iBlockState, 3);
        }
    }
}

