/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseSubsystem;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class BaseModClient<MOD extends BaseMod<? extends BaseModClient>>
implements IGuiHandler {
    MOD base;
    boolean debugSound = false;
    Map<Integer, Class<? extends GuiScreen>> screenClasses = new HashMap<Integer, Class<? extends GuiScreen>>();
    protected IRenderingManager renderingManager;
    protected String[] renderingManagerClasses = new String[]{"gcewing.architecture.BaseAORenderingManager", "gcewing.architecture.BaseRenderingManager"};

    public BaseModClient(MOD MOD) {
        this.base = MOD;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        this.registerSavedVillagerSkins();
        for (BaseSubsystem baseSubsystem : ((BaseMod)this.base).subsystems) {
            baseSubsystem.registerBlockRenderers();
            baseSubsystem.registerItemRenderers();
        }
        if (this.renderingManager == null && this.renderingManagerRequired()) {
            this.getRenderingManager();
        }
        if (this.renderingManager != null) {
            this.renderingManager.preInit();
        }
    }

    public void init(FMLInitializationEvent fMLInitializationEvent) {
    }

    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        for (BaseSubsystem baseSubsystem : ((BaseMod)this.base).subsystems) {
            baseSubsystem.registerModelLocations();
            baseSubsystem.registerTileEntityRenderers();
            baseSubsystem.registerEntityRenderers();
            baseSubsystem.registerScreens();
            baseSubsystem.registerOtherClient();
        }
        if (this.renderingManager != null) {
            this.renderingManager.postInit();
        }
    }

    void registerSavedVillagerSkins() {
    }

    void registerOther() {
    }

    void registerScreens() {
    }

    public void addScreen(Enum enum_, Class<? extends GuiScreen> clazz) {
        this.addScreen(enum_.ordinal(), clazz);
    }

    public void addScreen(int n, Class<? extends GuiScreen> clazz) {
        this.screenClasses.put(n, clazz);
    }

    protected void registerBlockRenderers() {
    }

    protected void registerItemRenderers() {
    }

    protected void registerEntityRenderers() {
    }

    protected void registerTileEntityRenderers() {
    }

    public void addTileEntityRenderer(Class<? extends TileEntity> clazz, TileEntitySpecialRenderer tileEntitySpecialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(clazz, (TileEntitySpecialRenderer)tileEntitySpecialRenderer);
    }

    public void addEntityRenderer(Class<? extends Entity> clazz, Render render) {
        RenderingRegistry.registerEntityRenderingHandler(clazz, (Render)render);
    }

    public void addEntityRenderer(Class<? extends Entity> clazz, Class<? extends Render> clazz2) {
        Render render;
        try {
            render = clazz2.newInstance();
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        this.addEntityRenderer(clazz, render);
    }

    public static void openClientGui(GuiScreen guiScreen) {
        FMLClientHandler.instance().getClient().func_147108_a(guiScreen);
    }

    public ResourceLocation textureLocation(String string) {
        return ((BaseMod)this.base).resourceLocation("textures/" + string);
    }

    public void bindTexture(String string) {
        BaseModClient.bindTexture(this.textureLocation(string));
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(resourceLocation);
    }

    public Object getServerGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return ((BaseMod)this.base).getServerGuiElement(n, entityPlayer, world, n2, n3, n4);
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return this.getClientGuiElement(n, entityPlayer, world, new BlockPos(n2, n3, n4));
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        Class<? extends GuiScreen> clazz;
        int n2 = n >> 16;
        n &= 0xFFFF;
        Object object = null;
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: for id %s\n", n);
        }
        if ((clazz = this.screenClasses.get(n)) != null) {
            block14: {
                Class<? extends Container> clazz2;
                if (((BaseMod)this.base).debugGui) {
                    System.out.printf("BaseModClient.getClientGuiElement: Instantiating %s\n", clazz);
                }
                if ((clazz2 = ((BaseMod)this.base).containerClasses.get(n)) != null) {
                    try {
                        Object object2;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Looking for constructor taking %s\n", clazz2);
                        }
                        Constructor<? extends GuiScreen> constructor = clazz.getConstructor(clazz2);
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating container\n", new Object[0]);
                        }
                        if ((object2 = ((BaseMod)this.base).createGuiElement(clazz2, entityPlayer, world, blockPos, n2)) == null) break block14;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating screen with container\n", new Object[0]);
                        }
                        try {
                            object = constructor.newInstance(object2);
                        }
                        catch (Exception exception) {
                            BaseMod.reportExceptionCause(exception);
                            return null;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (object == null) {
                object = ((BaseMod)this.base).createGuiElement(clazz, entityPlayer, world, blockPos, n2);
            }
        } else {
            object = this.getGuiScreen(n, entityPlayer, world, blockPos, n2);
        }
        ((BaseMod)this.base).setModOf(object);
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: returning %s\n", object);
        }
        return object;
    }

    GuiScreen getGuiScreen(int n, EntityPlayer entityPlayer, World world, BlockPos blockPos, int n2) {
        System.out.printf("%s: BaseModClient.getGuiScreen: No GuiScreen class found for gui id %d\n", this, n);
        return null;
    }

    public void addBlockRenderer(Block block, ICustomRenderer iCustomRenderer) {
        this.getRenderingManager().addBlockRenderer(block, iCustomRenderer);
    }

    public void addItemRenderer(Item item, ICustomRenderer iCustomRenderer) {
        this.getRenderingManager().addItemRenderer(item, iCustomRenderer);
    }

    public IModel getModel(String string) {
        return this.getRenderingManager().getModel(string);
    }

    public ModelResourceLocation modelResourceLocation(String string, String string2) {
        return new ModelResourceLocation(((BaseMod)this.base).resourceLocation(string), string2);
    }

    public void registerModelLocations() {
    }

    protected Class lookForClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected IRenderingManager getRenderingManager() {
        if (this.renderingManager != null) {
            return this.renderingManager;
        }
        for (String string : this.renderingManagerClasses) {
            Class clazz = this.lookForClass(string);
            if (clazz == null) continue;
            try {
                Constructor constructor = clazz.getConstructor(BaseModClient.class);
                this.renderingManager = (IRenderingManager)constructor.newInstance(this);
                return this.renderingManager;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        throw new RuntimeException("No rendering manager found in package gcewing.architecture");
    }

    protected boolean renderingManagerRequired() {
        for (Block block : ((BaseMod)this.base).registeredBlocks) {
            if (!this.objectNeedsCustomRendering(block)) continue;
            return true;
        }
        for (Item item : ((BaseMod)this.base).registeredItems) {
            if (!this.objectNeedsCustomRendering(item)) continue;
            return true;
        }
        return false;
    }

    protected boolean objectNeedsCustomRendering(Object object) {
        return object instanceof BaseMod.ITextureConsumer && ((BaseMod.ITextureConsumer)object).getTextureNames() != null;
    }

    public static interface IModel {
        public AxisAlignedBB getBounds();

        public void addBoxesToList(Trans3 var1, List var2);

        public void render(Trans3 var1, IRenderTarget var2, ITexture ... var3);
    }

    public static interface IRenderTarget {
        public boolean isRenderingBreakEffects();

        public void setTexture(ITexture var1);

        public void setColor(double var1, double var3, double var5, double var7);

        public void setNormal(Vector3 var1);

        public void beginTriangle();

        public void beginQuad();

        public void addVertex(Vector3 var1, double var2, double var4);

        public void addProjectedVertex(Vector3 var1, EnumFacing var2);

        public void endFace();
    }

    public static interface ITiledTexture
    extends ITexture {
        public ITexture tile(int var1, int var2);
    }

    public static interface ITexture {
        public ResourceLocation location();

        public int tintIndex();

        public double red();

        public double green();

        public double blue();

        public double interpolateU(double var1);

        public double interpolateV(double var1);

        public boolean isEmissive();

        public boolean isProjected();

        public boolean isSolid();

        public ITexture tinted(int var1);

        public ITexture colored(double var1, double var3, double var5);

        public ITexture projected();

        public ITexture emissive();

        public ITiledTexture tiled(int var1, int var2);
    }

    public static interface ICustomRenderer {
        public void renderBlock(IBlockAccess var1, BlockPos var2, IBlockState var3, IRenderTarget var4, BlockRenderLayer var5, Trans3 var6);

        public void renderItemStack(ItemStack var1, IRenderTarget var2, Trans3 var3);
    }

    public static interface IRenderingManager {
        public void preInit();

        public void postInit();

        public void addBlockRenderer(Block var1, ICustomRenderer var2);

        public void addItemRenderer(Item var1, ICustomRenderer var2);

        public IModel getModel(String var1);
    }
}

