/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BaseModelRenderer
implements BaseModClient.ICustomRenderer {
    protected BaseModClient.IModel model;
    protected BaseModClient.ITexture[] textures;
    protected Vector3 origin;

    public BaseModelRenderer(BaseModClient.IModel iModel, BaseModClient.ITexture ... iTextureArray) {
        this(iModel, Vector3.zero, iTextureArray);
    }

    public BaseModelRenderer(BaseModClient.IModel iModel, Vector3 vector3, BaseModClient.ITexture ... iTextureArray) {
        this.model = iModel;
        this.textures = iTextureArray;
        this.origin = vector3;
    }

    @Override
    public void renderBlock(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, BaseModClient.IRenderTarget iRenderTarget, BlockRenderLayer blockRenderLayer, Trans3 trans3) {
        BaseMod.IBlock iBlock = (BaseMod.IBlock)iBlockState.func_177230_c();
        Trans3 trans32 = trans3.t(iBlock.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState, Vector3.zero)).translate(this.origin);
        this.model.render(trans32, iRenderTarget, this.textures);
    }

    @Override
    public void renderItemStack(ItemStack itemStack, BaseModClient.IRenderTarget iRenderTarget, Trans3 trans3) {
        Block block;
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlock && (block = Block.func_149634_a((Item)item)) instanceof BaseMod.IBlock) {
            trans3 = trans3.t(((BaseMod.IBlock)block).itemTransformation());
        }
        this.model.render(trans3.translate(this.origin), iRenderTarget, this.textures);
    }
}

