/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBlock;
import gcewing.architecture.BaseTileEntity;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseOrientation {
    public static boolean debugPlacement = false;
    public static BaseBlock.IOrientationHandler orient4WaysByState = new Orient4WaysByState();
    public static BaseBlock.IOrientationHandler orient24WaysByTE = new Orient24WaysByTE();

    public static class Orient24WaysByTE
    extends BaseBlock.Orient1Way {
        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Vector3 vector3) {
            TileEntity tileEntity = iBlockAccess.func_175625_s(blockPos);
            if (tileEntity instanceof BaseTileEntity) {
                BaseTileEntity baseTileEntity = (BaseTileEntity)tileEntity;
                return Trans3.sideTurn(vector3, baseTileEntity.side, baseTileEntity.turn);
            }
            return super.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState, vector3);
        }
    }

    public static class Orient4WaysByState
    implements BaseBlock.IOrientationHandler {
        public static IProperty FACING = new PropertyTurn("facing");

        @Override
        public void defineProperties(BaseBlock baseBlock) {
            baseBlock.addProperty(FACING);
        }

        @Override
        public IBlockState onBlockPlaced(Block block, World world, BlockPos blockPos, EnumFacing enumFacing, float f, float f2, float f3, IBlockState iBlockState, EntityLivingBase entityLivingBase) {
            EnumFacing enumFacing2 = entityLivingBase.func_174811_aO();
            if (debugPlacement) {
                System.out.printf("BaseOrientation.Orient4WaysByState: Placing block with FACING = %s\n", enumFacing2);
            }
            return iBlockState.func_177226_a(FACING, (Comparable)enumFacing2);
        }

        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Vector3 vector3) {
            int n;
            EnumFacing enumFacing = (EnumFacing)iBlockState.func_177229_b(FACING);
            switch (enumFacing) {
                case NORTH: {
                    n = 0;
                    break;
                }
                case WEST: {
                    n = 1;
                    break;
                }
                case SOUTH: {
                    n = 2;
                    break;
                }
                case EAST: {
                    n = 3;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return new Trans3(vector3).turn(n);
        }
    }

    public static class PropertyTurn
    extends PropertyEnum<EnumFacing> {
        protected static EnumFacing[] values = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.NORTH};
        protected static Collection valueList = Arrays.asList(values);

        public PropertyTurn(String string) {
            super(string, EnumFacing.class, valueList);
        }
    }
}

