/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseTileInventory;
import gcewing.architecture.Shape;
import gcewing.architecture.ShapePage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class SawbenchTE
extends BaseTileInventory {
    public static final int materialSlot = 0;
    public static final int resultSlot = 1;
    public static final int[] materialSideSlots = new int[]{0};
    public static final int[] resultSideSlots = new int[]{1};
    public static boolean allowAutomation = false;
    public static ShapePage[] pages = new ShapePage[]{new ShapePage("Roofing", Shape.RoofTile, Shape.RoofOuterCorner, Shape.RoofInnerCorner, Shape.RoofRidge, Shape.RoofSmartRidge, Shape.RoofValley, Shape.RoofSmartValley, Shape.RoofOverhang, Shape.RoofOverhangOuterCorner, Shape.RoofOverhangInnerCorner, Shape.RoofOverhangGableLH, Shape.RoofOverhangGableRH, Shape.RoofOverhangGableEndLH, Shape.RoofOverhangGableEndRH, Shape.RoofOverhangRidge, Shape.RoofOverhangValley, Shape.BevelledOuterCorner, Shape.BevelledInnerCorner), new ShapePage("Rounded", Shape.Cylinder, Shape.CylinderHalf, Shape.CylinderQuarter, Shape.CylinderLargeQuarter, Shape.AnticylinderLargeQuarter, Shape.Pillar, Shape.Post, Shape.Pole, Shape.SphereFull, Shape.SphereHalf, Shape.SphereQuarter, Shape.SphereEighth, Shape.SphereEighthLarge, Shape.SphereEighthLargeRev), new ShapePage("Classical", Shape.PillarBase, Shape.Pillar, Shape.DoricCapital, Shape.DoricTriglyph, Shape.DoricTriglyphCorner, Shape.DoricMetope, Shape.IonicCapital, Shape.CorinthianCapital, Shape.Architrave, Shape.ArchitraveCorner, Shape.CorniceLH, Shape.CorniceRH, Shape.CorniceEndLH, Shape.CorniceEndRH, Shape.CorniceRidge, Shape.CorniceValley, Shape.CorniceBottom), new ShapePage("Window", Shape.WindowFrame, Shape.WindowCorner, Shape.WindowMullion), new ShapePage("Arches", Shape.ArchD1, Shape.ArchD2, Shape.ArchD3A, Shape.ArchD3B, Shape.ArchD3C, Shape.ArchD4A, Shape.ArchD4B, Shape.ArchD4C), new ShapePage("Railings", Shape.BalustradePlain, Shape.BalustradePlainOuterCorner, Shape.BalustradePlainInnerCorner, Shape.BalustradePlainWithNewel, Shape.BalustradePlainEnd, Shape.BanisterPlainTop, Shape.BanisterPlain, Shape.BanisterPlainBottom, Shape.BanisterPlainEnd, Shape.BanisterPlainInnerCorner, Shape.BalustradeFancy, Shape.BalustradeFancyCorner, Shape.BalustradeFancyWithNewel, Shape.BalustradeFancyNewel, Shape.BanisterFancyTop, Shape.BanisterFancy, Shape.BanisterFancyBottom, Shape.BanisterFancyEnd, Shape.BanisterFancyNewelTall), new ShapePage("Other", Shape.CladdingSheet, Shape.Slab, Shape.Stairs, Shape.StairsOuterCorner, Shape.StairsInnerCorner)};
    public IInventory inventory = new InventoryBasic("Items", false, 2);
    public int selectedPage = 0;
    public int[] selectedSlots = new int[pages.length];
    public boolean pendingMaterialUsage = false;

    public Shape getSelectedShape() {
        int n;
        if (this.selectedPage >= 0 && this.selectedPage < pages.length && (n = this.selectedSlots[this.selectedPage]) >= 0 && n < pages[this.selectedPage].size()) {
            return pages[this.selectedPage].get(n);
        }
        return null;
    }

    @Override
    protected IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        super.func_70299_a(n, itemStack);
        this.updateResultSlot();
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        if (n == 1) {
            this.usePendingMaterial();
        }
        ItemStack itemStack = super.func_70298_a(n, n2);
        this.updateResultSlot();
        return itemStack;
    }

    public ItemStack usePendingMaterial() {
        ItemStack itemStack = this.func_70301_a(0);
        if (this.pendingMaterialUsage) {
            this.pendingMaterialUsage = false;
            this.inventory.func_70298_a(0, this.materialMultiple());
        }
        return itemStack;
    }

    public void returnUnusedMaterial(ItemStack itemStack) {
        if (!this.pendingMaterialUsage) {
            ItemStack itemStack2 = this.func_70301_a(0);
            ItemStack itemStack3 = this.func_70301_a(1);
            int n = this.materialMultiple();
            int n2 = this.resultMultiple();
            if (itemStack3 != null && itemStack3.field_77994_a == n2) {
                if (itemStack2 != null) {
                    itemStack2.field_77994_a += n;
                } else {
                    itemStack2 = itemStack;
                    itemStack2.field_77994_a = n;
                }
                this.inventory.func_70299_a(0, itemStack2);
                this.pendingMaterialUsage = true;
            }
        }
    }

    public int[] getAccessibleSlotsFromSide(int n) {
        if (n == 1) {
            return materialSideSlots;
        }
        return resultSideSlots;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.selectedPage = nBTTagCompound.func_74762_e("Page");
        int[] nArray = nBTTagCompound.func_74759_k("Slots");
        if (nArray != null) {
            for (int i = 0; i < pages.length; ++i) {
                int n = i < nArray.length ? nArray[i] : 0;
                this.selectedSlots[i] = n >= 0 && n < pages[i].size() ? n : 0;
            }
        }
        this.pendingMaterialUsage = nBTTagCompound.func_74767_n("PMU");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nBTTagCompound) {
        super.func_189515_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Page", this.selectedPage);
        nBTTagCompound.func_74783_a("Slots", this.selectedSlots);
        nBTTagCompound.func_74757_a("PMU", this.pendingMaterialUsage);
        return nBTTagCompound;
    }

    public void setSelectedShape(int n, int n2) {
        if (n >= 0 && n < pages.length) {
            this.selectedPage = n;
            if (n2 >= 0 && n2 < pages[this.selectedPage].size()) {
                this.selectedSlots[this.selectedPage] = n2;
                this.func_70296_d();
                this.updateResultSlot();
                BaseMod.sendTileEntityUpdate(this);
            }
        }
    }

    void updateResultSlot() {
        ItemStack itemStack = this.func_70301_a(1);
        if (itemStack == null || this.pendingMaterialUsage) {
            ItemStack itemStack2 = this.makeResultStack();
            if (!ItemStack.func_77989_b((ItemStack)itemStack2, (ItemStack)itemStack)) {
                this.inventory.func_70299_a(1, itemStack2);
            }
            this.pendingMaterialUsage = itemStack2 != null;
        }
    }

    protected ItemStack makeResultStack() {
        Block block;
        Item item;
        ItemStack itemStack;
        Shape shape = this.getSelectedShape();
        if (shape != null && (itemStack = this.func_70301_a(0)) != null && itemStack.field_77994_a >= shape.materialUsed && (item = itemStack.func_77973_b()) instanceof ItemBlock && this.isAcceptableMaterial(block = Block.func_149634_a((Item)item))) {
            return shape.kind.newStack(shape, block, itemStack.func_77952_i(), shape.itemsProduced);
        }
        return null;
    }

    protected boolean isAcceptableMaterial(Block block) {
        String string = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
        System.out.printf("SawbenchTE.isAcceptableMaterial: %s %s\n", string, block.func_149739_a());
        if (block == Blocks.field_150359_w || block == Blocks.field_150399_cn || block instanceof BlockSlab || string.startsWith("chisel:glass")) {
            return true;
        }
        return block.func_176223_P().func_185917_h() && !block.func_149716_u();
    }

    int materialMultiple() {
        Shape shape;
        int n = 1;
        ItemStack itemStack = this.func_70301_a(0);
        if (itemStack != null && (shape = Block.func_149634_a((Item)itemStack.func_77973_b())) instanceof BlockSlab) {
            n = 2;
        }
        if ((shape = this.getSelectedShape()) != null) {
            return n * shape.materialUsed;
        }
        return 0;
    }

    int resultMultiple() {
        Shape shape = this.getSelectedShape();
        if (shape != null) {
            return shape.itemsProduced;
        }
        return 0;
    }

    @Override
    public boolean func_180462_a(int n, ItemStack itemStack, EnumFacing enumFacing) {
        return n == 0;
    }

    @Override
    public boolean func_180461_b(int n, ItemStack itemStack, EnumFacing enumFacing) {
        if (enumFacing == EnumFacing.DOWN) {
            return allowAutomation && n == 1;
        }
        return n == 0;
    }
}

