/*
 * Decompiled with CFR 0.152.
 */
package gunn.modcurrency.mod.container;

import gunn.modcurrency.mod.client.gui.util.INBTInventory;
import gunn.modcurrency.mod.container.slot.SlotCustomizable;
import gunn.modcurrency.mod.item.ItemWallet;
import gunn.modcurrency.mod.item.ModItems;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ContainerWallet
extends Container
implements INBTInventory {
    private final int HOTBAR_SLOT_COUNT = 9;
    private final int PLAYER_INV_ROW_COUNT = 3;
    private final int PLAYER_INV_COLUMN_COUNT = 9;
    private final int PLAYER_INV_TOTAL_COUNT = 27;
    private final int PLAYER_TOTAL_COUNT = 36;
    private final int WALLET_COLUMN_COUNT = 9;
    private final int WALLET_ROW_COUNT = ItemWallet.WALLET_ROW_COUNT;
    private final int WALLET_TOTAL_COUNT = 9 * this.WALLET_ROW_COUNT;
    private final int PLAYER_FIRST_SLOT_INDEX = 0;
    private final int WALLET_FIRST_SLOT_INDEX = 36;
    private final int GUI_XPOS_OFFPUT = -19;
    private ItemStackHandler itemStackHandler;

    public ContainerWallet(EntityPlayer player, ItemStack wallet) {
        if (!wallet.func_77942_o()) {
            NBTTagCompound compound = new NBTTagCompound();
            wallet.func_77982_d(compound);
            this.writeInventoryTag(wallet, new ItemStackHandler(this.WALLET_TOTAL_COUNT));
        }
        this.didInventorySizeChange(wallet, player);
        this.setupPlayerInv(player.field_71071_by);
        this.setupWalletInv(wallet);
        this.checkmetadataOpen(wallet);
    }

    private void setupPlayerInv(InventoryPlayer invPlayer) {
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int HOTBAR_XPOS = 27;
        int HOTBAR_YPOS = 178;
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)invPlayer, x, 27 + 18 * x + -19, 178));
        }
        int PLAYER_INV_XPOS = 27;
        int PLAYER_INV_YPOS = 120;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNum = 9 + y * 9 + x;
                int xpos = 27 + x * 18;
                int ypos = 120 + y * 18;
                this.func_75146_a(new Slot((IInventory)invPlayer, slotNum, xpos + -19, ypos));
            }
        }
    }

    private void setupWalletInv(ItemStack wallet) {
        this.itemStackHandler = this.readInventoryTag(wallet, this.WALLET_TOTAL_COUNT);
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        for (int y = 0; y < this.WALLET_ROW_COUNT; ++y) {
            block6: for (int x = 0; x < 9; ++x) {
                int slotNum = y * 9 + x;
                int xpos = 7 + x * 18;
                switch (y) {
                    default: {
                        this.func_75146_a((Slot)new SlotCustomizable((IItemHandler)this.itemStackHandler, slotNum, xpos, 35, ModItems.itemBanknote));
                        continue block6;
                    }
                    case 1: {
                        this.func_75146_a((Slot)new SlotCustomizable((IItemHandler)this.itemStackHandler, slotNum, xpos, 54, ModItems.itemBanknote));
                        continue block6;
                    }
                    case 2: {
                        this.func_75146_a((Slot)new SlotCustomizable((IItemHandler)this.itemStackHandler, slotNum, xpos, 18, ModItems.itemBanknote));
                        continue block6;
                    }
                    case 3: {
                        this.func_75146_a((Slot)new SlotCustomizable((IItemHandler)this.itemStackHandler, slotNum, xpos, 72, ModItems.itemBanknote));
                    }
                }
            }
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= 0 && slotId <= 36 + this.WALLET_TOTAL_COUNT && player.func_184614_ca() != ((Slot)this.field_75151_b.get(slotId)).func_75211_c()) {
            ItemStack stack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
            this.writeInventoryTag(player.func_184614_ca(), this.itemStackHandler);
            this.checkmetadataOpen(player.func_184614_ca());
            return stack;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack sourceStack = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (playerIn.func_184614_ca() == ((Slot)this.field_75151_b.get(index)).func_75211_c() || slot == null || !slot.func_75216_d()) return sourceStack;
        ItemStack copyStack = slot.func_75211_c();
        sourceStack = copyStack.func_77946_l();
        if (index < 36) {
            if (slot.func_75211_c().func_77973_b() != ModItems.itemBanknote) return null;
            if (this.func_75135_a(copyStack, 36, 36 + this.WALLET_TOTAL_COUNT, false)) return sourceStack;
            return null;
        }
        if (index < 36 || index >= 36 + this.WALLET_TOTAL_COUNT) return null;
        if (this.func_75135_a(copyStack, 0, 36, false)) return sourceStack;
        return null;
    }

    public void didInventorySizeChange(ItemStack stack, EntityPlayer player) {
        ItemStackHandler handler = this.readInventoryTag(stack, this.WALLET_TOTAL_COUNT);
        int oldSize = handler.getSlots();
        if (oldSize != this.WALLET_TOTAL_COUNT) {
            int i;
            ItemStack[] oldInventory = new ItemStack[oldSize];
            for (i = 0; i < oldSize; ++i) {
                oldInventory[i] = handler.getStackInSlot(i);
            }
            handler.setSize(this.WALLET_TOTAL_COUNT);
            if (oldSize < this.WALLET_TOTAL_COUNT) {
                for (i = 0; i < oldSize; ++i) {
                    handler.setStackInSlot(i, oldInventory[i]);
                }
                this.writeInventoryTag(stack, handler);
            } else {
                for (i = 0; i < this.WALLET_TOTAL_COUNT; ++i) {
                    handler.setStackInSlot(i, oldInventory[i]);
                }
                this.writeInventoryTag(stack, handler);
                for (i = this.WALLET_TOTAL_COUNT; i < oldSize; ++i) {
                    if (oldInventory[i] == null) continue;
                    World world = player.func_130014_f_();
                    BlockPos pos = player.func_180425_c();
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), oldInventory[i]));
                }
            }
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (playerIn.func_184614_ca().func_77973_b() == ModItems.itemWallet) {
            this.checkMetadataClosed(playerIn.func_184614_ca());
        }
    }

    public void checkMetadataClosed(ItemStack stack) {
        int slotsFilled = 0;
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            if (this.itemStackHandler.getStackInSlot(i) == null) continue;
            ++slotsFilled;
        }
        int meta = 0;
        if (slotsFilled != 0) {
            if (slotsFilled >= 1 && slotsFilled < 4 * ItemWallet.WALLET_ROW_COUNT) {
                meta = 1;
            } else if (slotsFilled >= 4 * ItemWallet.WALLET_ROW_COUNT && slotsFilled < 7 * ItemWallet.WALLET_ROW_COUNT) {
                meta = 2;
            } else if (slotsFilled >= 7 * ItemWallet.WALLET_ROW_COUNT && slotsFilled <= 9 * ItemWallet.WALLET_ROW_COUNT) {
                meta = 3;
            }
        }
        stack.func_77964_b(meta);
    }

    public void checkmetadataOpen(ItemStack stack) {
        int slotsFilled = 0;
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            if (this.itemStackHandler.getStackInSlot(i) == null) continue;
            ++slotsFilled;
        }
        int meta = 4;
        if (slotsFilled > 0) {
            meta = 5;
        }
        stack.func_77964_b(meta);
        if (slotsFilled == 0) {
            meta = 0;
        } else if (slotsFilled >= 1 && slotsFilled < 4 * ItemWallet.WALLET_ROW_COUNT) {
            meta = 1;
        } else if (slotsFilled >= 4 * ItemWallet.WALLET_ROW_COUNT && slotsFilled < 7 * ItemWallet.WALLET_ROW_COUNT) {
            meta = 2;
        } else if (slotsFilled >= 7 * ItemWallet.WALLET_ROW_COUNT && slotsFilled <= 9 * ItemWallet.WALLET_ROW_COUNT) {
            meta = 3;
        }
        NBTTagCompound compound = stack.func_77978_p();
        compound.func_74768_a("full", meta);
        stack.func_77982_d(compound);
    }
}

