/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit.commands;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.bukkit.BukkitWorld;
import com.khorn.terraincontrol.bukkit.TCPerm;
import com.khorn.terraincontrol.bukkit.TXPlugin;
import com.khorn.terraincontrol.bukkit.commands.BaseCommand;
import com.khorn.terraincontrol.logging.LogMarker;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ReloadCommand
extends BaseCommand {
    public ReloadCommand(TXPlugin _plugin) {
        super(_plugin);
        this.name = "reload";
        this.perm = TCPerm.CMD_RELOAD.node;
        this.usage = "reload [world_name]";
        this.workOnConsole = true;
    }

    @Override
    public boolean onCommand(CommandSender sender, List<String> args) {
        BukkitWorld world = (BukkitWorld)this.getWorld(sender, args.size() > 0 ? args.get(0) : "");
        if (world == null) {
            sender.sendMessage(ERROR_COLOR + "World not found. Either you are not in a world with Open Terrain Generator, or you are the console.");
            return false;
        }
        world.reloadSettings();
        sender.sendMessage(MESSAGE_COLOR + "Configs for world '" + world.getName() + "' reloaded");
        if (sender instanceof Player) {
            TerrainControl.log(LogMarker.INFO, "{} reloaded the config files for world '{}'.", sender.getName(), world.getName());
        }
        return true;
    }
}

