/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit.util;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.WeightedMobSpawnGroup;
import com.khorn.terraincontrol.configuration.standard.MojangSettings;
import com.khorn.terraincontrol.logging.LogMarker;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.server.v1_10_R1.BiomeBase;
import net.minecraft.server.v1_10_R1.EntityInsentient;
import net.minecraft.server.v1_10_R1.EntityTypes;
import net.minecraft.server.v1_10_R1.EnumCreatureType;
import net.minecraft.server.v1_10_R1.WeightedRandom;

public final class MobSpawnGroupHelper {
    private static final Map<Class<? extends EntityInsentient>, String> CLASS_TO_NAME_MAP;
    private static final Map<String, Class<? extends EntityInsentient>> NAME_TO_CLASS_MAP;
    private static final Field WEIGHT_FIELD;

    private static EnumCreatureType toEnumCreatureType(MojangSettings.EntityCategory type) {
        switch (type) {
            case MONSTER: {
                return EnumCreatureType.MONSTER;
            }
            case CREATURE: {
                return EnumCreatureType.CREATURE;
            }
            case AMBIENT_CREATURE: {
                return EnumCreatureType.AMBIENT;
            }
            case WATER_CREATURE: {
                return EnumCreatureType.WATER_CREATURE;
            }
        }
        throw new AssertionError((Object)("Unknown mob type: " + (Object)((Object)type)));
    }

    private static WeightedMobSpawnGroup fromMinecraftGroup(BiomeBase.BiomeMeta biomeMeta) {
        return new WeightedMobSpawnGroup(MobSpawnGroupHelper.fromMinecraftClass(biomeMeta.b), MobSpawnGroupHelper.getWeight(biomeMeta), biomeMeta.c, biomeMeta.d);
    }

    private static int getWeight(BiomeBase.BiomeMeta biomeMeta) {
        try {
            return WEIGHT_FIELD.getInt(biomeMeta);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<WeightedMobSpawnGroup> getListFromMinecraftBiome(BiomeBase biome, MojangSettings.EntityCategory type) {
        List mobList = biome.getMobs(MobSpawnGroupHelper.toEnumCreatureType(type));
        return MobSpawnGroupHelper.fromMinecraftList(mobList);
    }

    static List<WeightedMobSpawnGroup> fromMinecraftList(Collection<BiomeBase.BiomeMeta> biomeMetas) {
        ArrayList<WeightedMobSpawnGroup> result = new ArrayList<WeightedMobSpawnGroup>();
        for (BiomeBase.BiomeMeta meta : biomeMetas) {
            result.add(MobSpawnGroupHelper.fromMinecraftGroup(meta));
        }
        return result;
    }

    public static List<BiomeBase.BiomeMeta> toMinecraftlist(Collection<WeightedMobSpawnGroup> weightedMobSpawnGroups) {
        ArrayList<BiomeBase.BiomeMeta> biomeList = new ArrayList<BiomeBase.BiomeMeta>();
        for (WeightedMobSpawnGroup mobGroup : weightedMobSpawnGroups) {
            Class<? extends EntityInsentient> entityClass = MobSpawnGroupHelper.toMinecraftClass(mobGroup.getInternalName());
            if (entityClass != null) {
                biomeList.add(new BiomeBase.BiomeMeta(entityClass, mobGroup.getWeight(), mobGroup.getMin(), mobGroup.getMax()));
                continue;
            }
            if (!TerrainControl.getPluginConfig().SpawnLog) continue;
            TerrainControl.log(LogMarker.WARN, "Mob type {} not found", mobGroup.getInternalName());
        }
        return biomeList;
    }

    static Class<? extends EntityInsentient> toMinecraftClass(String mobName) {
        return NAME_TO_CLASS_MAP.get(mobName);
    }

    private static String fromMinecraftClass(Class<?> entityClass) {
        return CLASS_TO_NAME_MAP.get(entityClass);
    }

    static {
        try {
            Map nameToClassMap;
            Map classToNameMap;
            Field classToNameMapField = EntityTypes.class.getDeclaredField("d");
            classToNameMapField.setAccessible(true);
            CLASS_TO_NAME_MAP = classToNameMap = (Map)classToNameMapField.get(null);
            Field nameToClassMapField = EntityTypes.class.getDeclaredField("c");
            nameToClassMapField.setAccessible(true);
            NAME_TO_CLASS_MAP = nameToClassMap = (Map)nameToClassMapField.get(null);
            WEIGHT_FIELD = WeightedRandom.WeightedRandomChoice.class.getDeclaredField("a");
            WEIGHT_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Reflection error", e);
        }
    }
}

