/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.customobjects.bo3.BO3Check;
import com.khorn.terraincontrol.customobjects.bo3.BO3Config;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import java.util.List;

public class LightCheck
extends BO3Check {
    public int minLightLevel;
    public int maxLightLevel;

    public LightCheck(BO3Config config, List<String> args) throws InvalidConfigException {
        super(config);
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -100, 100);
        this.z = this.readInt(args.get(2), -100, 100);
        this.minLightLevel = this.readInt(args.get(3), 0, 16);
        this.maxLightLevel = this.readInt(args.get(4), this.minLightLevel, 16);
    }

    private LightCheck(BO3Config config) {
        super(config);
    }

    @Override
    public boolean preventsSpawn(LocalWorld world, int x, int y, int z) {
        int lightLevel = world.getLightLevel(x, y, z);
        return lightLevel < this.minLightLevel || lightLevel > this.maxLightLevel;
    }

    @Override
    public String toString() {
        return "LightCheck(" + this.x + ',' + this.y + ',' + this.z + ',' + this.minLightLevel + ',' + this.maxLightLevel + ')';
    }

    @Override
    public BO3Check rotate() {
        LightCheck rotatedCheck = new LightCheck((BO3Config)this.getHolder());
        rotatedCheck.x = this.z;
        rotatedCheck.y = this.y;
        rotatedCheck.z = -this.x;
        rotatedCheck.minLightLevel = this.minLightLevel;
        rotatedCheck.maxLightLevel = this.maxLightLevel;
        return rotatedCheck;
    }
}

