/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.customobjects.bo3.BO3Config;
import com.khorn.terraincontrol.customobjects.bo3.BO3PlaceableFunction;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.SpawnableObject;
import com.khorn.terraincontrol.util.Rotation;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultStructurePart;
import java.util.List;
import java.util.Random;

public class MinecraftObjectFunction
extends BO3PlaceableFunction {
    public DefaultStructurePart structurePart;
    public Rotation rotation = Rotation.NORTH;

    public MinecraftObjectFunction(BO3Config config, List<String> args) throws InvalidConfigException {
        super(config);
        this.assureSize(4, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.structurePart = DefaultStructurePart.getDefaultStructurePart(args.get(3));
    }

    public MinecraftObjectFunction(BO3Config holder) {
        super(holder);
    }

    @Override
    public String toString() {
        return "MinecraftObject(" + this.x + ',' + this.y + ',' + this.z + ',' + (Object)((Object)this.structurePart) + ')';
    }

    @Override
    public MinecraftObjectFunction rotate() {
        MinecraftObjectFunction rotatedBlock = new MinecraftObjectFunction((BO3Config)this.getHolder());
        rotatedBlock.x = this.z;
        rotatedBlock.y = this.y;
        rotatedBlock.z = -this.x;
        rotatedBlock.rotation = this.rotation.next();
        return rotatedBlock;
    }

    @Override
    public void spawn(LocalWorld world, Random random, int x, int y, int z) {
        SpawnableObject object = world.getMojangStructurePart(this.structurePart.getPath());
        object.spawnForced(world, random, this.rotation, x, y, z);
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BO3Config> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        MinecraftObjectFunction block = (MinecraftObjectFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z;
    }
}

