/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.customobjects.bo3;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.customobjects.Branch;
import com.khorn.terraincontrol.customobjects.CustomObjectCoordinate;
import com.khorn.terraincontrol.customobjects.bo3.BO3Config;
import com.khorn.terraincontrol.customobjects.bo3.BranchFunction;
import com.khorn.terraincontrol.customobjects.bo3.BranchNode;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class WeightedBranchFunction
extends BranchFunction
implements Branch {
    public double cumulativeChance = 0.0;

    public WeightedBranchFunction(BO3Config config, List<String> args) throws InvalidConfigException {
        super(config);
        this.branches = new TreeSet();
        this.cumulativeChance = this.readArgs(args, true);
    }

    @Override
    public CustomObjectCoordinate toCustomObjectCoordinate(LocalWorld world, Random random, int x, int y, int z) {
        double randomChance = random.nextDouble() * (this.totalChance != -1.0 ? this.totalChance : (this.cumulativeChance >= 100.0 ? this.cumulativeChance : 100.0));
        for (BranchNode branch : this.branches) {
            if (!(branch.getChance() >= randomChance)) continue;
            return new CustomObjectCoordinate(branch.getCustomObject(), branch.getRotation(), x + this.x, y + this.y, z + this.z);
        }
        return null;
    }

    @Override
    protected String getConfigName() {
        return "WeightedBranch";
    }
}

