/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.client.events;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.logging.LogMarker;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.InputStream;

public class DimensionSyncPacket {
    private ByteBuf data = Unpooled.buffer();
    DataInputStream wrappedStream;

    public void consumePacket(ByteBuf data) {
        int clientProtocolVersion;
        int serverProtocolVersion = data.readInt();
        if (serverProtocolVersion != (clientProtocolVersion = 5)) {
            throw new RuntimeException("Client is using a different version of OTG than server!");
        }
        this.wrappedStream = new DataInputStream((InputStream)new ByteBufInputStream(data));
    }

    public ByteBuf getData() {
        return this.data;
    }

    public void setData(ByteBuf data) {
        this.data = data;
    }

    public void execute() {
        try {
            ((ForgeEngine)TerrainControl.getEngine()).getWorldLoader().registerClientWorld(this.wrappedStream);
        }
        catch (Exception e) {
            TerrainControl.log(LogMarker.FATAL, "Failed to receive packet", new Object[0]);
            TerrainControl.printStackTrace(LogMarker.FATAL, e);
        }
    }
}

