/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.events;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.ConfigToNetworkSender;
import com.khorn.terraincontrol.forge.DimensionData;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.OTGDimensionInfo;
import com.khorn.terraincontrol.forge.TXDimensionManager;
import com.khorn.terraincontrol.forge.TXPlugin;
import com.khorn.terraincontrol.forge.client.events.DimensionSyncPacket;
import com.khorn.terraincontrol.logging.LogMarker;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerTracker {
    @SubscribeEvent
    public void onConnectionCreated(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        PlayerTracker.SendWorldAndBiomeConfigs(event.getManager(), true);
    }

    public static void SendAllWorldAndBiomeConfigsToAllPlayers(MinecraftServer server) {
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            PlayerTracker.SendWorldAndBiomeConfigs(player.field_71135_a.field_147371_a, server.func_71264_H());
        }
    }

    private static void SendWorldAndBiomeConfigs(NetworkManager networkManager, boolean isSinglePlayer) {
        OTGDimensionInfo otgDimData = TXDimensionManager.GetOrderedDimensionData();
        ByteBuf nettyBuffer = Unpooled.buffer();
        ByteBufOutputStream stream = new ByteBufOutputStream(nettyBuffer);
        try {
            stream.writeInt(5);
            stream.writeInt(otgDimData.orderedDimensions.size() + 1);
            LocalWorld localWorld = ((ForgeEngine)TerrainControl.getEngine()).getOverWorld();
            try {
                stream.writeInt(0);
                ConfigToNetworkSender.writeConfigsToStream(localWorld.getConfigs(), (DataOutput)stream, false);
            }
            catch (IOException e) {
                TerrainControl.printStackTrace(LogMarker.FATAL, e);
            }
            for (int i = 0; i <= otgDimData.highestOrder; ++i) {
                if (!otgDimData.orderedDimensions.containsKey(i)) continue;
                DimensionData dimData = otgDimData.orderedDimensions.get(i);
                localWorld = TerrainControl.getWorld(dimData.dimensionName);
                if (localWorld == null) {
                    localWorld = TerrainControl.getUnloadedWorld(dimData.dimensionName);
                }
                try {
                    stream.writeInt(dimData.dimensionId);
                    ConfigToNetworkSender.writeConfigsToStream(localWorld.getConfigs(), (DataOutput)stream, false);
                    continue;
                }
                catch (IOException e) {
                    TerrainControl.printStackTrace(LogMarker.FATAL, e);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        DimensionSyncPacket packet = new DimensionSyncPacket();
        packet.setData(nettyBuffer);
        TXPlugin.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DISPATCHER);
        TXPlugin.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(networkManager.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
        TXPlugin.channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }
}

