/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.generator;

import com.khorn.terraincontrol.BiomeIds;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.WeightedMobSpawnGroup;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.ForgeWorld;
import com.khorn.terraincontrol.forge.util.MobSpawnGroupHelper;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TXBiome
extends Biome {
    public static final int MAX_TC_BIOME_ID = 1023;
    private int skyColor;
    public final int generationId;

    private TXBiome(BiomeConfig config, BiomeIds id) {
        super((Biome.BiomeProperties)new BiomePropertiesCustom(config));
        this.generationId = id.getGenerationId();
        this.skyColor = config.skyColor;
        this.field_76761_J.clear();
        this.field_76762_K.clear();
        this.field_82914_M.clear();
        this.field_76755_L.clear();
        this.addMobs(this.field_76761_J, config.spawnMonstersMerged);
        this.addMobs(this.field_76762_K, config.spawnCreaturesMerged);
        this.addMobs(this.field_76755_L, config.spawnWaterCreaturesMerged);
        this.addMobs(this.field_82914_M, config.spawnAmbientCreaturesMerged);
    }

    public static Biome getOrCreateBiome(BiomeConfig biomeConfig, BiomeIds biomeIds, boolean isMainWorld) {
        Biome alreadyRegisteredBiome;
        ResourceLocation registryKey = ForgeWorld.vanillaResouceLocations.get(biomeIds.getGenerationId());
        if (registryKey == null) {
            int generationId = biomeIds.getGenerationId();
            String biomeNameForRegistry = StringHelper.toComputerFriendlyName(biomeConfig.getName());
            String resourceDomain = "OpenTerrainGenerator".toLowerCase();
            if (generationId >= 0 && generationId <= 39 || generationId >= 127 && generationId <= 167) {
                throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
            }
            registryKey = new ResourceLocation(resourceDomain, biomeNameForRegistry);
        }
        if ((alreadyRegisteredBiome = (Biome)Biome.field_185377_q.field_82596_a.get(registryKey)) != null) {
            if (isMainWorld) {
                ((ForgeEngine)TerrainControl.getEngine()).unRegisterForgeBiome(registryKey);
            } else {
                return alreadyRegisteredBiome;
            }
        }
        TXBiome customBiome = new TXBiome(biomeConfig, biomeIds);
        int savedBiomeId = biomeIds.getSavedId();
        ForgeEngine forgeEngine = (ForgeEngine)TerrainControl.getEngine();
        if (Biome.func_150568_d((int)1023) == null) {
            ResourceLocation maxTcBiomeKey = new ResourceLocation("OpenTerrainGenerator".toLowerCase(), "null");
            forgeEngine.registerForgeBiome(1023, maxTcBiomeKey, new TXBiome(biomeConfig, new BiomeIds(1023, 1023)));
        }
        if (biomeIds.isVirtual()) {
            Biome existingBiome = Biome.func_185357_a((int)savedBiomeId);
            if (existingBiome == null) {
                forgeEngine.registerForgeBiome(biomeIds.getGenerationId(), registryKey, customBiome);
                TerrainControl.log(LogMarker.TRACE, ",{},{},{}", biomeConfig.getName(), savedBiomeId, biomeIds.getGenerationId());
            } else {
                ResourceLocation existingBiomeKey = (ResourceLocation)Biome.field_185377_q.field_148758_b.get(existingBiome);
                forgeEngine.registerForgeBiome(biomeIds.getSavedId(), registryKey, customBiome);
                forgeEngine.registerForgeBiome(biomeIds.getSavedId(), existingBiomeKey, existingBiome);
                TerrainControl.log(LogMarker.TRACE, ",{},{},{}", biomeConfig.getName(), savedBiomeId, biomeIds.getGenerationId());
            }
        } else if (savedBiomeId < 256 && !biomeIds.isVirtual()) {
            Biome.field_185377_q.func_177775_a(savedBiomeId, (Object)registryKey, (Object)customBiome);
            TerrainControl.log(LogMarker.TRACE, ",{},{},{}", biomeConfig.getName(), savedBiomeId, biomeIds.getGenerationId());
        }
        return customBiome;
    }

    public int func_76731_a(float v) {
        return this.skyColor;
    }

    public String toString() {
        return "BiomeGenCustom of " + this.func_185359_l();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        if (this.func_185359_l().equals("Swampland") || this.func_185359_l().equals("Swampland M")) {
            double d0 = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
            return d0 < -0.1 ? 5011004 : 6975545;
        }
        return super.func_180627_b(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        if (this.func_185359_l().equals("Swampland") || this.func_185359_l().equals("Swampland M")) {
            return 6975545;
        }
        return super.func_180625_c(pos);
    }

    public void addMobs(List<Biome.SpawnListEntry> internalList, List<WeightedMobSpawnGroup> configList) {
        ArrayList<Object> newList = new ArrayList<Object>();
        ArrayList<Biome.SpawnListEntry> newListParent = new ArrayList<Biome.SpawnListEntry>();
        List<Biome.SpawnListEntry> spawnListEntry = MobSpawnGroupHelper.toMinecraftlist(configList);
        newList.addAll(spawnListEntry);
        for (Biome.SpawnListEntry spawnListEntry2 : internalList) {
            boolean bFound = false;
            for (Biome.SpawnListEntry spawnListEntry3 : newList) {
                if (!spawnListEntry3.field_76300_b.equals(spawnListEntry2.field_76300_b)) continue;
                bFound = true;
            }
            if (bFound) continue;
            newListParent.add(spawnListEntry2);
        }
        newList.addAll(newListParent);
        internalList.clear();
        for (Biome.SpawnListEntry spawnListEntry4 : newList) {
            if (spawnListEntry4.field_76292_a <= 0 || spawnListEntry4.field_76299_d <= 0) continue;
            internalList.add(spawnListEntry4);
        }
    }

    private static class BiomePropertiesCustom
    extends Biome.BiomeProperties {
        BiomePropertiesCustom(BiomeConfig biomeConfig) {
            super(biomeConfig.getName());
            this.func_185398_c(biomeConfig.biomeHeight);
            this.func_185400_d(biomeConfig.biomeVolatility);
            this.func_185395_b(biomeConfig.biomeWetness);
            this.func_185402_a(biomeConfig.waterColor);
            float safeTemperature = biomeConfig.biomeTemperature;
            if ((double)safeTemperature >= 0.1 && (double)safeTemperature <= 0.2) {
                safeTemperature = (double)safeTemperature >= 1.5 ? 0.2f : 0.1f;
            }
            this.func_185410_a(safeTemperature);
            if ((double)biomeConfig.biomeWetness <= 1.0E-4) {
                this.func_185396_a();
            }
            if (biomeConfig.biomeTemperature <= 0.15f) {
                this.func_185411_b();
            }
        }
    }
}

