/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.gui;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.WorldConfig;
import com.khorn.terraincontrol.configuration.io.FileSettingsReader;
import com.khorn.terraincontrol.configuration.io.SettingsMap;
import com.khorn.terraincontrol.forge.ForgeEngine;
import com.khorn.terraincontrol.forge.gui.GuiHandler;
import com.khorn.terraincontrol.forge.gui.TXGuiEnterWorldName;
import com.khorn.terraincontrol.forge.gui.TXGuiWorldSelection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class TXGuiCreateWorld
extends GuiScreen
implements GuiYesNoCallback {
    GuiScreen sender;
    GuiTextField txtWorldName;
    GuiTextField txtSeed;
    GuiButton btnavailableWorld1;
    GuiButton btnavailableWorld2;
    GuiButton btnavailableWorld3;
    GuiButton btnavailableWorldPrev;
    GuiButton btnavailableWorldNext;
    GuiButton btnavailableWorldNew;
    GuiButton btnavailableWorldClone;
    GuiButton btnavailableWorldDelete1;
    GuiButton btnavailableWorldDelete2;
    GuiButton btnavailableWorldDelete3;
    GuiTextField txtPregenRadius;
    GuiTextField txtWorldBorderRadius;
    GuiButton btnGameMode;
    GuiButton btnAllowCheats;
    GuiButton btnBonusChest;
    GuiButton btnCreateWorld;
    boolean bBtnCreateNewWorldClicked;
    final String[] field_146327_L = new String[]{"CON", "COM", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    WorldConfig selectedWorldConfig = null;
    String worldNameHelpText;
    String worldNameHelpText2;
    boolean askDeleteSettings = false;
    boolean askModCompatContinue = false;
    WorldSettings worldsettings = null;
    String worldNameToDelete = "";
    boolean selectingWorldName = false;
    boolean cloning = false;

    public TXGuiCreateWorld(GuiScreen sender) {
        this.sender = sender;
    }

    public void func_73876_c() {
        this.txtSeed.func_146178_a();
        this.txtWorldBorderRadius.func_146178_a();
        this.txtPregenRadius.func_146178_a();
    }

    private void FillAvailableWorlds() {
        int pages;
        GuiHandler.worlds.clear();
        ArrayList<String> worldNames = new ArrayList<String>();
        File TCWorldsDirectory = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds");
        if (TCWorldsDirectory.exists() && TCWorldsDirectory.isDirectory()) {
            for (File worldDir : TCWorldsDirectory.listFiles()) {
                if (!worldDir.isDirectory() || worldDir.getName().toLowerCase().trim().startsWith("dim-")) continue;
                worldNames.add(worldDir.getName());
                if (GuiHandler.worlds.containsKey(worldDir.getName())) continue;
                File worldConfigFile = new File(worldDir, "WorldConfig.ini");
                SettingsMap settingsMap = FileSettingsReader.read(worldDir.getName(), worldConfigFile);
                WorldConfig worldConfig = new WorldConfig(worldDir, settingsMap, null, null);
                GuiHandler.worlds.put(worldDir.getName(), worldConfig);
            }
        }
        if (GuiHandler.pageNumber > (pages = (int)Math.ceil((double)worldNames.size() / 3.0)) - 1) {
            GuiHandler.pageNumber = pages - 1;
        }
        if (GuiHandler.pageNumber < 0) {
            GuiHandler.pageNumber = 0;
        }
        int i = 0;
        this.btnavailableWorld1.field_146126_j = "";
        this.btnavailableWorld2.field_146126_j = "";
        this.btnavailableWorld3.field_146126_j = "";
        this.btnavailableWorldDelete1.field_146126_j = "";
        this.btnavailableWorldDelete2.field_146126_j = "";
        this.btnavailableWorldDelete3.field_146126_j = "";
        for (String worldName : worldNames) {
            if (++i == GuiHandler.pageNumber * 3 + 1) {
                this.btnavailableWorld1.field_146126_j = worldName;
                this.btnavailableWorldDelete1.field_146126_j = "X";
            }
            if (i == GuiHandler.pageNumber * 3 + 2) {
                this.btnavailableWorld2.field_146126_j = worldName;
                this.btnavailableWorldDelete2.field_146126_j = "X";
            }
            if (i != GuiHandler.pageNumber * 3 + 3) continue;
            this.btnavailableWorld3.field_146126_j = worldName;
            this.btnavailableWorldDelete3.field_146126_j = "X";
        }
        this.btnavailableWorld1.field_146124_l = !this.btnavailableWorld1.field_146126_j.equals("") && !this.btnavailableWorld1.field_146126_j.equals(GuiHandler.worldName);
        this.btnavailableWorld2.field_146124_l = !this.btnavailableWorld2.field_146126_j.equals("") && !this.btnavailableWorld2.field_146126_j.equals(GuiHandler.worldName);
        this.btnavailableWorld3.field_146124_l = !this.btnavailableWorld3.field_146126_j.equals("") && !this.btnavailableWorld3.field_146126_j.equals(GuiHandler.worldName);
        this.btnavailableWorldDelete1.field_146124_l = !this.btnavailableWorld1.field_146126_j.equals("");
        this.btnavailableWorldDelete2.field_146124_l = !this.btnavailableWorld2.field_146126_j.equals("");
        boolean bl = this.btnavailableWorldDelete3.field_146124_l = !this.btnavailableWorld3.field_146126_j.equals("");
        if (worldNames.size() > 3) {
            this.btnavailableWorldPrev.field_146124_l = true;
            this.btnavailableWorldNext.field_146124_l = true;
        } else {
            this.btnavailableWorldPrev.field_146124_l = false;
            this.btnavailableWorldNext.field_146124_l = false;
        }
        if (GuiHandler.pageNumber == 0) {
            this.btnavailableWorldPrev.field_146124_l = false;
        }
        if (GuiHandler.pageNumber == pages - 1) {
            this.btnavailableWorldNext.field_146124_l = false;
        }
    }

    private void previousPage() {
        if (--GuiHandler.pageNumber < 0) {
            GuiHandler.pageNumber = 0;
        }
        this.FillAvailableWorlds();
    }

    private void nextPage() {
        ++GuiHandler.pageNumber;
        this.FillAvailableWorlds();
    }

    private void updateWorldName() {
        GuiHandler.worldName = this.txtWorldName.func_146179_b().trim();
        boolean bl = this.btnCreateWorld.field_146124_l = this.txtWorldName.func_146179_b().length() > 0;
        if (GuiHandler.worldName.length() == 0) {
            this.worldNameHelpText = "World name cannot be empty";
        } else {
            for (int i = 0; i != GuiHandler.worldName.length(); ++i) {
                if (ChatAllowedCharacters.func_71566_a((char)GuiHandler.worldName.charAt(i))) continue;
                GuiHandler.worldName.replace(GuiHandler.worldName.charAt(i), '_');
            }
            GuiHandler.worldName = this.getCorrectWorldName(this.field_146297_k.func_71359_d(), GuiHandler.worldName);
            this.worldNameHelpText = this.field_146297_k.func_71359_d().func_75803_c(GuiHandler.worldName) != null ? "Existing world will be deleted!" : "New world dir will be created";
            boolean usingPreset = false;
            File TCWorldsDirectory = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds");
            if (TCWorldsDirectory.exists() && TCWorldsDirectory.isDirectory()) {
                for (File worldDir : TCWorldsDirectory.listFiles()) {
                    if (!worldDir.isDirectory() || !GuiHandler.worldName.equals(worldDir.getName())) continue;
                    this.selectedWorldConfig = GuiHandler.worlds.get(worldDir.getName());
                    if (GuiHandler.selectedWorldName == null || !GuiHandler.selectedWorldName.equals(GuiHandler.worldName)) {
                        ((ForgeEngine)TerrainControl.getEngine()).getPregenerator().setPregenerationRadius(this.selectedWorldConfig.PreGenerationRadius);
                        ((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius = this.selectedWorldConfig.WorldBorderRadius;
                        GuiHandler.seed = this.selectedWorldConfig.worldSeed;
                        WorldInfo worldInfo = this.field_146297_k.func_71359_d().func_75803_c(GuiHandler.worldName);
                        if (worldInfo != null) {
                            GuiHandler.seed = worldInfo.func_76063_b() + "";
                            GuiHandler.gameModeString = worldInfo.func_76077_q().func_77149_b();
                            GuiHandler.hardCore = worldInfo.func_76093_s();
                            GuiHandler.allowCheats = worldInfo.func_76086_u();
                        } else {
                            GuiHandler.gameModeString = "survival";
                            GuiHandler.hardCore = false;
                            GuiHandler.allowCheats = false;
                        }
                        GuiHandler.bonusChest = false;
                    }
                    GuiHandler.selectedWorldName = worldDir.getName();
                    usingPreset = true;
                    break;
                }
            }
            if (usingPreset) {
                this.worldNameHelpText2 = "Using existing settings";
                this.txtPregenRadius.func_146180_a(((ForgeEngine)TerrainControl.getEngine()).getPregenerator().getPregenerationRadius() + "");
                this.txtWorldBorderRadius.func_146180_a(((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius + "");
                this.txtSeed.func_146180_a(GuiHandler.seed);
            } else {
                GuiHandler.selectedWorldName = null;
                this.selectedWorldConfig = null;
                this.worldNameHelpText2 = "Using default settings";
            }
            this.btnavailableWorldClone.field_146124_l = GuiHandler.selectedWorldName != null;
        }
        this.FillAvailableWorlds();
        this.updateButtons();
    }

    public String getCorrectWorldName(ISaveFormat anvilSaveConverter, String worldName) {
        worldName = worldName.replaceAll("[\\./\"]", "_");
        for (String s1 : this.field_146327_L) {
            if (!worldName.equalsIgnoreCase(s1)) continue;
            worldName = "_" + worldName + "_";
        }
        return worldName;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73878_a(boolean ok, int worldId) {
        if (this.askDeleteSettings) {
            if (ok) {
                GuiYesNo guiyesno = this.askDeleteSettings(this, this.worldNameToDelete);
                this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
                File TCWorldsDirectory = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds");
                if (TCWorldsDirectory.exists() && TCWorldsDirectory.isDirectory()) {
                    for (File worldDir : TCWorldsDirectory.listFiles()) {
                        if (!worldDir.isDirectory() || !worldDir.getName().equals(this.worldNameToDelete)) continue;
                        TXGuiCreateWorld.deleteRecursive(worldDir);
                        break;
                    }
                }
                ISaveFormat isaveformat = this.field_146297_k.func_71359_d();
                isaveformat.func_75800_d();
                isaveformat.func_75802_e(this.worldNameToDelete);
                if (GuiHandler.selectedWorldName != null && this.worldNameToDelete.trim().toLowerCase().equals(GuiHandler.selectedWorldName.trim().toLowerCase())) {
                    this.FillAvailableWorlds();
                    GuiHandler.pageNumber = 0;
                    if (GuiHandler.worlds.size() > 0) {
                        if (TCWorldsDirectory.exists() && TCWorldsDirectory.isDirectory()) {
                            for (File worldDir : TCWorldsDirectory.listFiles()) {
                                if (!worldDir.isDirectory() || worldDir.getName().toLowerCase().startsWith("dim-")) continue;
                                GuiHandler.selectedWorldName = worldDir.getName();
                                break;
                            }
                        }
                        this.selectedWorldConfig = GuiHandler.worlds.get(GuiHandler.selectedWorldName);
                        ((ForgeEngine)TerrainControl.getEngine()).getPregenerator().setPregenerationRadius(this.selectedWorldConfig.PreGenerationRadius);
                        ((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius = this.selectedWorldConfig.WorldBorderRadius;
                        GuiHandler.seed = this.selectedWorldConfig.worldSeed;
                        WorldInfo worldInfo = this.field_146297_k.func_71359_d().func_75803_c(GuiHandler.selectedWorldName);
                        if (worldInfo != null) {
                            GuiHandler.seed = worldInfo.func_76063_b() + "";
                            GuiHandler.gameModeString = worldInfo.func_76077_q().func_77149_b();
                            GuiHandler.hardCore = worldInfo.func_76093_s();
                            GuiHandler.allowCheats = worldInfo.func_76086_u();
                        }
                    } else {
                        GuiHandler.selectedWorldName = null;
                        this.selectedWorldConfig = null;
                        GuiHandler.seed = "";
                        ((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius = 0;
                        ((ForgeEngine)TerrainControl.getEngine()).getPregenerator().setPregenerationRadius(0);
                    }
                    GuiHandler.worldName = GuiHandler.selectedWorldName;
                    this.txtWorldName.func_146180_a(GuiHandler.worldName != null ? GuiHandler.worldName : "");
                }
                this.updateWorldName();
                this.updateButtons();
            }
            this.field_146297_k.func_147108_a((GuiScreen)new TXGuiCreateWorld(new TXGuiWorldSelection(null)));
        } else if (this.askModCompatContinue) {
            if (ok) {
                this.DeleteWorldFiles();
                ((ForgeEngine)TerrainControl.getEngine()).getPregenerator().resetPregenerator();
                this.field_146297_k.func_71371_a(GuiHandler.worldName, this.txtWorldName.func_146179_b().trim(), this.worldsettings);
            } else {
                this.field_146297_k.func_147108_a((GuiScreen)new TXGuiCreateWorld(new TXGuiWorldSelection(null)));
            }
        } else if (this.selectingWorldName && ok) {
            if (this.cloning) {
                File sourceDir = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds/" + GuiHandler.selectedWorldName);
                if (sourceDir.exists() && sourceDir.isDirectory()) {
                    for (File worldDir : sourceDir.listFiles()) {
                        if (!worldDir.isDirectory() || !worldDir.getName().equals(this.worldNameToDelete)) continue;
                        TXGuiCreateWorld.deleteRecursive(worldDir);
                        break;
                    }
                } else {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiErrorScreen("Error", "Could find source directory \"" + GuiHandler.selectedWorldName + "\""));
                    return;
                }
                File destDir = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds/" + GuiHandler.newWorldName);
                try {
                    FileUtils.copyDirectory((File)sourceDir, (File)destDir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiErrorScreen("Error", "Could not copy directory \"" + GuiHandler.selectedWorldName + "\", files may be in use."));
                    return;
                }
                GuiHandler.selectedWorldName = GuiHandler.newWorldName;
                this.updateWorldName();
                this.updateButtons();
            } else {
                this.selectedWorldConfig = null;
                GuiHandler.selectedWorldName = null;
                GuiHandler.worldName = GuiHandler.newWorldName;
                this.txtWorldName.func_146180_a(GuiHandler.newWorldName);
                GuiHandler.seed = "";
                ((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius = 0;
                ((ForgeEngine)TerrainControl.getEngine()).getPregenerator().setPregenerationRadius(0);
                GuiHandler.gameModeString = "survival";
                GuiHandler.hardCore = false;
                GuiHandler.allowCheats = false;
                GuiHandler.bonusChest = false;
                this.updateWorldName();
                this.updateButtons();
            }
        }
    }

    public static void deleteRecursive(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    TXGuiCreateWorld.deleteRecursive(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    public GuiYesNo askDeleteSettings(GuiYesNoCallback p_152129_0_, String worldName) {
        this.askDeleteSettings = true;
        this.selectingWorldName = false;
        this.askModCompatContinue = false;
        String s1 = "Delete the OpenTerrainGenerator world settings for '" + worldName + "'?";
        String s2 = "This will also delete any world (directory) named '" + worldName + "'";
        String s3 = "Delete";
        String s4 = "Cancel";
        GuiYesNo guiyesno = new GuiYesNo(p_152129_0_, s1, s2, s3, s4, 0);
        return guiyesno;
    }

    public GuiYesNo askModCompatContinue(GuiYesNoCallback p_152129_0_, boolean customMobSpawnerEnabled, boolean biomesOPlentyEnabled) {
        this.askDeleteSettings = false;
        this.selectingWorldName = false;
        this.askModCompatContinue = true;
        String s1 = "Warning: " + (biomesOPlentyEnabled ? " Biomes o' plenty may cause crashes." : "") + (customMobSpawnerEnabled ? " CustomMobSpawner may break OTG mob spawning." : "");
        String s2 = "It is recommended that you disable or remove " + (customMobSpawnerEnabled && biomesOPlentyEnabled ? "these mods." : "this mod.");
        String s3 = "Continue";
        String s4 = "Back";
        GuiYesNo guiyesno = new GuiYesNo(p_152129_0_, s1, s2, s3, s4, 0);
        return guiyesno;
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (this.txtSeed.func_146206_l()) {
            this.txtSeed.func_146201_a(p_73869_1_, p_73869_2_);
            GuiHandler.seed = this.txtSeed.func_146179_b();
        } else if (this.txtPregenRadius.func_146206_l()) {
            this.txtPregenRadius.func_146201_a(p_73869_1_, p_73869_2_);
            try {
                ((ForgeEngine)TerrainControl.getEngine()).getPregenerator().setPregenerationRadius(Integer.parseInt(this.txtPregenRadius.func_146179_b()));
            }
            catch (NumberFormatException ex) {
                ((ForgeEngine)TerrainControl.getEngine()).getPregenerator().setPregenerationRadius(0);
            }
        } else if (this.txtWorldBorderRadius.func_146206_l()) {
            this.txtWorldBorderRadius.func_146201_a(p_73869_1_, p_73869_2_);
            try {
                ((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius = Integer.parseInt(this.txtWorldBorderRadius.func_146179_b());
            }
            catch (NumberFormatException ex) {
                ((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius = 0;
            }
        }
        if (p_73869_2_ == 28 || p_73869_2_ == 156) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
        this.updateWorldName();
    }

    protected void func_73864_a(int p_73864_1_, int p_73864_2_, int p_73864_3_) throws IOException {
        super.func_73864_a(p_73864_1_, p_73864_2_, p_73864_3_);
        this.txtSeed.func_146192_a(p_73864_1_, p_73864_2_, p_73864_3_);
        this.txtWorldName.func_146192_a(p_73864_1_, p_73864_2_, p_73864_3_);
        this.txtPregenRadius.func_146192_a(p_73864_1_, p_73864_2_, p_73864_3_);
        this.txtWorldBorderRadius.func_146192_a(p_73864_1_, p_73864_2_, p_73864_3_);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            GuiYesNo guiyesno;
            if (button.field_146127_k == 3) {
                if (this.btnavailableWorld1.field_146126_j.length() > 0 && !this.btnavailableWorld1.field_146126_j.equalsIgnoreCase("")) {
                    this.txtWorldName.func_146180_a(this.btnavailableWorld1.field_146126_j);
                } else {
                    this.txtWorldName.func_146180_a("New World");
                }
                this.updateWorldName();
            }
            if (button.field_146127_k == 4) {
                if (this.btnavailableWorld2.field_146126_j.length() > 0 && !this.btnavailableWorld2.field_146126_j.equalsIgnoreCase("")) {
                    this.txtWorldName.func_146180_a(this.btnavailableWorld2.field_146126_j);
                } else {
                    this.txtWorldName.func_146180_a("New World");
                }
                this.updateWorldName();
            }
            if (button.field_146127_k == 5) {
                if (this.btnavailableWorld3.field_146126_j.length() > 0 && !this.btnavailableWorld3.field_146126_j.equalsIgnoreCase("")) {
                    this.txtWorldName.func_146180_a(this.btnavailableWorld3.field_146126_j);
                } else {
                    this.txtWorldName.func_146180_a("New World");
                }
                this.updateWorldName();
            }
            if (button.field_146127_k == 8 && this.btnavailableWorld1.field_146126_j.length() > 0 && !this.btnavailableWorld1.field_146126_j.equalsIgnoreCase("")) {
                guiyesno = this.askDeleteSettings(this, this.btnavailableWorld1.field_146126_j);
                this.worldNameToDelete = this.btnavailableWorld1.field_146126_j.trim();
                this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
            }
            if (button.field_146127_k == 9 && this.btnavailableWorld2.field_146126_j.length() > 0 && !this.btnavailableWorld2.field_146126_j.equalsIgnoreCase("")) {
                guiyesno = this.askDeleteSettings(this, this.btnavailableWorld2.field_146126_j);
                this.worldNameToDelete = this.btnavailableWorld2.field_146126_j.trim();
                this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
            }
            if (button.field_146127_k == 10 && this.btnavailableWorld3.field_146126_j.length() > 0 && !this.btnavailableWorld3.field_146126_j.equalsIgnoreCase("")) {
                guiyesno = this.askDeleteSettings(this, this.btnavailableWorld3.field_146126_j);
                this.worldNameToDelete = this.btnavailableWorld3.field_146126_j.trim();
                this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
            }
            if (button.field_146127_k == 6) {
                this.previousPage();
            }
            if (button.field_146127_k == 7) {
                this.nextPage();
            }
            if (button.field_146127_k == 1) {
                this.field_146297_k.func_147108_a(this.sender);
            } else if (button.field_146127_k == 0) {
                if (this.bBtnCreateNewWorldClicked) {
                    return;
                }
                this.bBtnCreateNewWorldClicked = true;
                long i = new Random().nextLong();
                String s = this.txtSeed.func_146179_b().trim();
                if (s != null && s.length() > 0) {
                    try {
                        long j = Long.parseLong(s);
                        if (j != 0L) {
                            i = j;
                        }
                    }
                    catch (NumberFormatException numberformatexception) {
                        i = s.hashCode();
                    }
                }
                ISaveFormat isaveformat = this.field_146297_k.func_71359_d();
                isaveformat.func_75800_d();
                isaveformat.func_75802_e(GuiHandler.worldName);
                WorldType.func_77130_a((String)"OTG").onGUICreateWorldPress();
                GameType gametype = GameType.func_77142_a((String)GuiHandler.gameModeString);
                this.worldsettings = new WorldSettings(i, gametype, true, GuiHandler.hardCore, WorldType.func_77130_a((String)"OTG"));
                this.worldsettings.func_82750_a("OpenTerrainGenerator");
                if (GuiHandler.bonusChest) {
                    this.worldsettings.func_77159_a();
                }
                if (GuiHandler.allowCheats) {
                    this.worldsettings.func_77166_b();
                }
                boolean biomesOPlentyEnabled = false;
                boolean customMobSpawnerEnabled = false;
                for (ModContainer mod : Loader.instance().getActiveModList()) {
                    if (mod.getName().toLowerCase().equals("biomes o' plenty")) {
                        biomesOPlentyEnabled = true;
                    }
                    if (mod.getName().toLowerCase().equals("drzhark's customspawner")) {
                        customMobSpawnerEnabled = true;
                    }
                    if (!biomesOPlentyEnabled || !customMobSpawnerEnabled) continue;
                    break;
                }
                if (biomesOPlentyEnabled || customMobSpawnerEnabled) {
                    GuiYesNo guiyesno2 = this.askModCompatContinue(this, customMobSpawnerEnabled, biomesOPlentyEnabled);
                    this.field_146297_k.func_147108_a((GuiScreen)guiyesno2);
                } else {
                    this.DeleteWorldFiles();
                    ((ForgeEngine)TerrainControl.getEngine()).getPregenerator().resetPregenerator();
                    this.field_146297_k.func_71371_a(GuiHandler.worldName, this.txtWorldName.func_146179_b().trim(), this.worldsettings);
                }
            } else if (button.field_146127_k == 11) {
                if (GuiHandler.gameModeString.equals("survival")) {
                    GuiHandler.gameModeString = "hardcore";
                    GuiHandler.hardCore = true;
                } else if (GuiHandler.gameModeString.equals("hardcore")) {
                    GuiHandler.gameModeString = "creative";
                    GuiHandler.hardCore = false;
                } else {
                    GuiHandler.gameModeString = "survival";
                    GuiHandler.hardCore = false;
                }
                this.updateButtons();
            }
            if (button.field_146127_k == 12) {
                GuiHandler.allowCheats = !GuiHandler.allowCheats;
                this.updateButtons();
            }
            if (button.field_146127_k == 13) {
                GuiHandler.bonusChest = !GuiHandler.bonusChest;
                this.updateButtons();
            }
            if (button.field_146127_k == 14 && GuiHandler.selectedWorldName != null) {
                this.cloning = true;
                this.askDeleteSettings = false;
                this.selectingWorldName = true;
                this.askModCompatContinue = false;
                this.FillAvailableWorlds();
                TXGuiEnterWorldName guiRenameWorld = new TXGuiEnterWorldName(this, GuiHandler.selectedWorldName);
                this.field_146297_k.func_147108_a((GuiScreen)guiRenameWorld);
            }
            if (button.field_146127_k == 15) {
                this.cloning = false;
                this.askDeleteSettings = false;
                this.selectingWorldName = true;
                this.askModCompatContinue = false;
                this.FillAvailableWorlds();
                TXGuiEnterWorldName guiRenameWorld = new TXGuiEnterWorldName(this, "New World");
                this.field_146297_k.func_147108_a((GuiScreen)guiRenameWorld);
            }
        }
    }

    private void DeleteWorldFiles() {
        File TCWorldsDirectory = new File(TerrainControl.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds");
        if (TCWorldsDirectory.exists() && TCWorldsDirectory.isDirectory()) {
            for (File worldDir : TCWorldsDirectory.listFiles()) {
                File pregeneratedChunksFile;
                File chunkProviderPopulatedChunksFile;
                File spawnedStructuresFile;
                File nullChunksFile;
                File structureDataFile;
                if (!worldDir.isDirectory() || !GuiHandler.worldName.equals(worldDir.getName())) continue;
                File StructureDataDirectory = new File(worldDir.getAbsolutePath() + "/StructureData");
                if (StructureDataDirectory.exists()) {
                    TXGuiCreateWorld.deleteRecursive(StructureDataDirectory);
                }
                if ((structureDataFile = new File(worldDir.getAbsolutePath() + "/StructureData.txt")).exists()) {
                    TXGuiCreateWorld.deleteRecursive(structureDataFile);
                }
                if ((nullChunksFile = new File(worldDir.getAbsolutePath() + "/NullChunks.txt")).exists()) {
                    TXGuiCreateWorld.deleteRecursive(nullChunksFile);
                }
                if ((spawnedStructuresFile = new File(worldDir.getAbsolutePath() + "/SpawnedStructures.txt")).exists()) {
                    TXGuiCreateWorld.deleteRecursive(spawnedStructuresFile);
                }
                if ((chunkProviderPopulatedChunksFile = new File(worldDir.getAbsolutePath() + "/ChunkProviderPopulatedChunks.txt")).exists()) {
                    TXGuiCreateWorld.deleteRecursive(chunkProviderPopulatedChunksFile);
                }
                if (!(pregeneratedChunksFile = new File(worldDir.getAbsolutePath() + "/PregeneratedChunks.txt")).exists()) break;
                TXGuiCreateWorld.deleteRecursive(pregeneratedChunksFile);
                break;
            }
        }
    }

    private void updateButtons() {
        if (GuiHandler.hardCore) {
            GuiHandler.allowCheats = false;
            GuiHandler.bonusChest = false;
            this.btnAllowCheats.field_146124_l = false;
            this.btnBonusChest.field_146124_l = false;
        } else {
            this.btnAllowCheats.field_146124_l = true;
            this.btnBonusChest.field_146124_l = true;
        }
        this.btnGameMode.field_146126_j = I18n.func_135052_a((String)"selectWorld.gameMode", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("selectWorld.gameMode." + GuiHandler.gameModeString), (Object[])new Object[0]);
        this.btnBonusChest.field_146126_j = I18n.func_135052_a((String)"selectWorld.bonusItems", (Object[])new Object[0]) + " ";
        this.btnBonusChest.field_146126_j = GuiHandler.bonusChest ? this.btnBonusChest.field_146126_j + I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : this.btnBonusChest.field_146126_j + I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
        this.btnAllowCheats.field_146126_j = I18n.func_135052_a((String)"selectWorld.allowCommands", (Object[])new Object[0]) + " ";
        this.btnAllowCheats.field_146126_j = GuiHandler.allowCheats ? this.btnAllowCheats.field_146126_j + I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : this.btnAllowCheats.field_146126_j + I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.txtWorldName = new GuiTextField(30, this.field_146289_q, this.field_146294_l / 2 - 164, 45, 160, 20);
        this.txtWorldName.func_146184_c(false);
        this.txtSeed = new GuiTextField(31, this.field_146289_q, this.field_146294_l / 2 - 164, 101, 160, 20);
        this.txtSeed.func_146195_b(true);
        this.txtSeed.func_146180_a(GuiHandler.seed != null ? GuiHandler.seed : "");
        int btnwidth = 136;
        this.btnavailableWorld1 = new GuiButton(3, this.field_146294_l / 2 + 6, 43, btnwidth, 20, "");
        this.btnavailableWorld2 = new GuiButton(4, this.field_146294_l / 2 + 6, 67, btnwidth, 20, "");
        this.btnavailableWorld3 = new GuiButton(5, this.field_146294_l / 2 + 6, 91, btnwidth, 20, "");
        this.btnavailableWorldPrev = new GuiButton(6, this.field_146294_l / 2 + 6, 115, 25, 20, "<");
        this.btnavailableWorldNext = new GuiButton(7, this.field_146294_l / 2 + 6 + 28, 115, 25, 20, ">");
        this.btnavailableWorldClone = new GuiButton(14, this.field_146294_l / 2 + 6 + 56, 115, 50, 20, "Clone");
        this.btnavailableWorldClone.field_146124_l = GuiHandler.selectedWorldName != null;
        this.btnavailableWorldNew = new GuiButton(15, this.field_146294_l / 2 + 6 + 110, 115, 50, 20, "New");
        this.btnavailableWorldDelete1 = new GuiButton(8, this.field_146294_l / 2 + 6 + btnwidth + 4, 43, 20, 20, "X");
        this.btnavailableWorldDelete2 = new GuiButton(9, this.field_146294_l / 2 + 6 + btnwidth + 4, 67, 20, 20, "X");
        this.btnavailableWorldDelete3 = new GuiButton(10, this.field_146294_l / 2 + 6 + btnwidth + 4, 91, 20, 20, "X");
        this.field_146292_n.add(this.btnavailableWorld1);
        this.field_146292_n.add(this.btnavailableWorld2);
        this.field_146292_n.add(this.btnavailableWorld3);
        this.field_146292_n.add(this.btnavailableWorldPrev);
        this.field_146292_n.add(this.btnavailableWorldNext);
        this.field_146292_n.add(this.btnavailableWorldClone);
        this.field_146292_n.add(this.btnavailableWorldNew);
        this.field_146292_n.add(this.btnavailableWorldDelete1);
        this.field_146292_n.add(this.btnavailableWorldDelete2);
        this.field_146292_n.add(this.btnavailableWorldDelete3);
        this.FillAvailableWorlds();
        this.txtPregenRadius = new GuiTextField(20, this.field_146289_q, this.field_146294_l / 2 - 164, 159, 50, 20);
        this.txtPregenRadius.func_146180_a(((ForgeEngine)TerrainControl.getEngine()).getPregenerator().getPregenerationRadius() + "");
        this.txtWorldBorderRadius = new GuiTextField(21, this.field_146289_q, this.field_146294_l / 2 - 164 + 210, 159, 50, 20);
        this.txtWorldBorderRadius.func_146180_a(((ForgeEngine)TerrainControl.getEngine()).WorldBorderRadius + "");
        this.btnGameMode = new GuiButton(11, this.field_146294_l / 2 - 166, 188, 122, 20, I18n.func_135052_a((String)"selectWorld.gameMode", (Object[])new Object[0]));
        this.btnAllowCheats = new GuiButton(12, this.field_146294_l / 2 - 39, 188, 100, 20, I18n.func_135052_a((String)"selectWorld.allowCommands", (Object[])new Object[0]));
        this.btnBonusChest = new GuiButton(13, this.field_146294_l / 2 + 66, 188, 100, 20, I18n.func_135052_a((String)"selectWorld.bonusItems", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnGameMode);
        this.field_146292_n.add(this.btnAllowCheats);
        this.field_146292_n.add(this.btnBonusChest);
        this.btnCreateWorld = new GuiButton(0, this.field_146294_l / 2 - 166, 213, 164, 20, I18n.func_135052_a((String)"selectWorld.create", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnCreateWorld);
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 2, 213, 164, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        if (GuiHandler.selectedWorldName != null) {
            this.txtWorldName.func_146180_a(GuiHandler.selectedWorldName);
        } else if (GuiHandler.worldName != null) {
            this.txtWorldName.func_146180_a(GuiHandler.worldName);
        } else if (this.btnavailableWorld1.field_146126_j.length() > 0 && !this.btnavailableWorld1.field_146126_j.equalsIgnoreCase("")) {
            this.txtWorldName.func_146180_a(this.btnavailableWorld1.field_146126_j);
        } else {
            this.txtWorldName.func_146180_a(I18n.func_135052_a((String)"selectWorld.newWorld", (Object[])new Object[0]));
        }
        this.updateWorldName();
        this.updateButtons();
    }

    public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"Create a new OpenTerrainGenerator world", (Object[])new Object[0]), this.field_146294_l / 2, 10, -1);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.enterName", (Object[])new Object[0]), this.field_146294_l / 2 - 164, 30, -6250336);
        this.func_73731_b(this.field_146289_q, this.worldNameHelpText, this.field_146294_l / 2 - 164, 70, -6250336);
        this.txtWorldName.func_146194_f();
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"World settings", (Object[])new Object[0]), this.field_146294_l / 2 + 9, 30, -6250336);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.enterSeed", (Object[])new Object[0]), this.field_146294_l / 2 - 164, 88, -6250336);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.seedInfo", (Object[])new Object[0]), this.field_146294_l / 2 - 164, 126, -6250336);
        this.txtSeed.func_146194_f();
        this.func_73731_b(this.field_146289_q, "Pre-generation radius", this.field_146294_l / 2 - 164, 145, -6250336);
        this.func_73731_b(this.field_146289_q, "World border radius", this.field_146294_l / 2 - 164 + 210, 145, -6250336);
        this.func_73731_b(this.field_146289_q, "chunks", this.field_146294_l / 2 - 164 + 60, 165, -6250336);
        this.func_73731_b(this.field_146289_q, "chunks", this.field_146294_l / 2 - 164 + 210 + 60, 165, -6250336);
        this.txtPregenRadius.func_146194_f();
        this.txtWorldBorderRadius.func_146194_f();
        super.func_73863_a(p_73863_1_, p_73863_2_, p_73863_3_);
    }
}

