/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.forge.util;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.WeightedMobSpawnGroup;
import com.khorn.terraincontrol.configuration.standard.MojangSettings;
import com.khorn.terraincontrol.logging.LogMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;

public final class MobSpawnGroupHelper {
    private static EnumCreatureType toEnumCreatureType(MojangSettings.EntityCategory type) {
        switch (type) {
            case MONSTER: {
                return EnumCreatureType.MONSTER;
            }
            case CREATURE: {
                return EnumCreatureType.CREATURE;
            }
            case AMBIENT_CREATURE: {
                return EnumCreatureType.AMBIENT;
            }
            case WATER_CREATURE: {
                return EnumCreatureType.WATER_CREATURE;
            }
        }
        throw new AssertionError((Object)("Unknown mob type: " + (Object)((Object)type)));
    }

    private static WeightedMobSpawnGroup fromMinecraftGroup(Biome.SpawnListEntry biomeMeta) {
        String mobName = MobSpawnGroupHelper.fromMinecraftClass(biomeMeta.field_76300_b);
        if (mobName == null) {
            return null;
        }
        return new WeightedMobSpawnGroup(mobName, biomeMeta.field_76292_a, biomeMeta.field_76301_c, biomeMeta.field_76299_d);
    }

    public static List<WeightedMobSpawnGroup> getListFromMinecraftBiome(Biome biome, MojangSettings.EntityCategory type) {
        List mobList = biome.func_76747_a(MobSpawnGroupHelper.toEnumCreatureType(type));
        return MobSpawnGroupHelper.fromMinecraftList(mobList);
    }

    static List<WeightedMobSpawnGroup> fromMinecraftList(Collection<Biome.SpawnListEntry> biomeMetas) {
        ArrayList<WeightedMobSpawnGroup> result = new ArrayList<WeightedMobSpawnGroup>();
        for (Biome.SpawnListEntry meta : biomeMetas) {
            WeightedMobSpawnGroup wMSG = MobSpawnGroupHelper.fromMinecraftGroup(meta);
            if (wMSG == null) continue;
            result.add(wMSG);
        }
        return result;
    }

    public static List<Biome.SpawnListEntry> toMinecraftlist(Collection<WeightedMobSpawnGroup> weightedMobSpawnGroups) {
        ArrayList<Biome.SpawnListEntry> biomeList = new ArrayList<Biome.SpawnListEntry>();
        for (WeightedMobSpawnGroup mobGroup : weightedMobSpawnGroups) {
            Class<? extends EntityLiving> entityClass = MobSpawnGroupHelper.toMinecraftClass(mobGroup.getInternalName());
            if (entityClass != null) {
                biomeList.add(new Biome.SpawnListEntry(entityClass, mobGroup.getWeight(), mobGroup.getMin(), mobGroup.getMax()));
                continue;
            }
            if (!TerrainControl.getPluginConfig().SpawnLog) continue;
            TerrainControl.log(LogMarker.WARN, "Mob type {} not found", mobGroup.getInternalName());
        }
        return biomeList;
    }

    static Class<? extends EntityLiving> toMinecraftClass(String mobName) {
        return (Class)EntityList.field_75625_b.get(mobName);
    }

    private static String fromMinecraftClass(Class<?> entityClass) {
        String mobName = (String)EntityList.field_75626_c.get(entityClass);
        if (mobName != null) {
            return mobName;
        }
        TerrainControl.log(LogMarker.DEBUG, "No EntityRegistry entry found for class: " + entityClass, new Object[0]);
        return null;
    }
}

