/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.biome;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.generator.biome.OutputType;

public abstract class BiomeGenerator {
    protected final LocalWorld world;

    public BiomeGenerator(LocalWorld world) {
        this.world = world;
    }

    public int[] getBiomesUnZoomed(int[] biomeArray, int x, int z, int xSize, int zSize, OutputType type) {
        return this.getBiomes(biomeArray, x, z, xSize, zSize, type);
    }

    public abstract int[] getBiomes(int[] var1, int var2, int var3, int var4, int var5, OutputType var6);

    public int getBiome(int blockX, int blockZ) throws UnsupportedOperationException {
        if (this.isCached()) {
            throw new AssertionError((Object)"isCached() == true, but getBiome is not overridden");
        }
        throw new UnsupportedOperationException("isCached() == false, so no single biome lookups");
    }

    public void cleanupCache() throws UnsupportedOperationException {
        if (this.isCached()) {
            throw new AssertionError((Object)"isCached() == true, but cleanupCache is not overridden");
        }
        throw new UnsupportedOperationException("isCached() == false, so no cache to cleanup");
    }

    public boolean canGenerateUnZoomed() {
        return false;
    }

    public boolean isCached() {
        return false;
    }

    public BiomeGenerator unwrap() {
        return this;
    }
}

