/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.biome.layers;

import com.khorn.terraincontrol.LocalBiome;
import com.khorn.terraincontrol.generator.biome.ArraysCache;
import com.khorn.terraincontrol.generator.biome.layers.Layer;
import java.util.ArrayList;
import java.util.List;

public class LayerBiomeInBiome
extends Layer {
    private final long worldSeed;
    private List<Isle> isles = new ArrayList<Isle>();

    public LayerBiomeInBiome(Layer childLayer, long worldSeed) {
        this.worldSeed = worldSeed;
        this.child = childLayer;
    }

    public void addIsle(LocalBiome biome, int chance, boolean[] biomeCanSpawnIn, boolean inOcean) {
        Isle isle = new Isle();
        isle.biomeId = (short)biome.getIds().getGenerationId();
        isle.chance = chance;
        isle.canSpawnIn = biomeCanSpawnIn;
        isle.inOcean = inOcean;
        isle.scrambledWorldSeed = LayerBiomeInBiome.getScrambledWorldSeed(4000 + isle.biomeId, this.worldSeed);
        this.isles.add(isle);
    }

    @Override
    public int[] getInts(ArraysCache cache, int x, int z, int xSize, int zSize) {
        int x0 = x - 1;
        int z0 = z - 1;
        int xSize0 = xSize + 2;
        int zSize0 = zSize + 2;
        int[] childInts = this.child.getInts(cache, x0, z0, xSize0, zSize0);
        int[] thisInts = cache.getArray(xSize * zSize);
        for (int zi = 0; zi < zSize; ++zi) {
            for (int xi = 0; xi < xSize; ++xi) {
                int selection = childInts[xi + 1 + (zi + 1) * xSize0];
                for (Isle isle : this.isles) {
                    int seCheck;
                    int swCheck;
                    int neCheck;
                    int nwCheck;
                    this.scrambledWorldSeed = isle.scrambledWorldSeed;
                    this.initChunkSeed(xi + x, zi + z);
                    boolean alreadySpawned = false;
                    if (isle.inOcean) {
                        nwCheck = childInts[xi + 0 + zi * xSize0] & 0x400;
                        neCheck = childInts[xi + 2 + zi * xSize0] & 0x400;
                        swCheck = childInts[xi + 0 + (zi + 2) * xSize0] & 0x400;
                        seCheck = childInts[xi + 2 + (zi + 2) * xSize0] & 0x400;
                        if ((selection & 0x400) == 0 && nwCheck == 0 && neCheck == 0 && swCheck == 0 && seCheck == 0 && this.nextInt(isle.chance) == 0) {
                            selection = selection & 0x1000 | selection & 0x300000 | 0x400 | isle.biomeId | 0x800;
                            alreadySpawned = true;
                        }
                    }
                    if (alreadySpawned) continue;
                    nwCheck = childInts[xi + 0 + zi * xSize0] & 0x3FF;
                    neCheck = childInts[xi + 2 + zi * xSize0] & 0x3FF;
                    swCheck = childInts[xi + 0 + (zi + 2) * xSize0] & 0x3FF;
                    seCheck = childInts[xi + 2 + (zi + 2) * xSize0] & 0x3FF;
                    if (!isle.canSpawnIn[selection & 0x3FF] || !isle.canSpawnIn[nwCheck] || !isle.canSpawnIn[neCheck] || !isle.canSpawnIn[swCheck] || !isle.canSpawnIn[seCheck] || this.nextInt(isle.chance) != 0) continue;
                    selection = selection & 0x400 | selection & 0x1000 | selection & 0x300000 | isle.biomeId | 0x800;
                }
                thisInts[xi + zi * xSize] = selection;
            }
        }
        return thisInts;
    }

    private static class Isle {
        short biomeId;
        int chance = 10;
        boolean[] canSpawnIn = new boolean[1024];
        long scrambledWorldSeed;
        boolean inOcean = false;

        private Isle() {
        }
    }
}

