/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.resource;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class Resource
extends ConfigFunction<BiomeConfig>
implements Comparable<Resource> {
    protected int frequency;
    protected LocalMaterialData material;
    protected double rarity;

    public static Resource createResource(BiomeConfig config, Class<? extends Resource> clazz, Object ... args) {
        ArrayList<String> stringArgs = new ArrayList<String>(args.length);
        for (Object arg : args) {
            stringArgs.add("" + arg);
        }
        try {
            return clazz.getConstructor(BiomeConfig.class, List.class).newInstance(config, stringArgs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Resource(BiomeConfig biomeConfig) throws InvalidConfigException {
        super(biomeConfig);
    }

    @Override
    public int compareTo(Resource o) {
        return o.getPriority() - this.getPriority();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Resource compare = (Resource)other;
        if (this.material == null && compare.material != null) {
            return false;
        }
        return this.material.equals(compare.material) && this.frequency == compare.frequency && this.rarity == compare.rarity;
    }

    public LocalMaterialData getMaterial() {
        return this.material;
    }

    public int getPriority() {
        return 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.material == null ? 0 : this.material.hashCode());
        hash = 53 * hash + this.frequency;
        hash = 53 * hash + (int)(Double.doubleToLongBits(this.rarity) ^ Double.doubleToLongBits(this.rarity) >>> 32);
        return hash;
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BiomeConfig> other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        Resource resource = (Resource)other;
        return resource.material.equals(this.material);
    }

    public final void process(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        if (!TerrainControl.fireResourceProcessEvent(this, world, random, villageInChunk, chunkCoord.getChunkX(), chunkCoord.getChunkZ())) {
            return;
        }
        this.spawnInChunk(world, random, villageInChunk, chunkCoord);
    }

    public abstract void spawn(LocalWorld var1, Random var2, boolean var3, int var4, int var5);

    protected void spawnInChunk(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        int chunkX = chunkCoord.getBlockXCenter();
        int chunkZ = chunkCoord.getBlockZCenter();
        for (int t = 0; t < this.frequency; ++t) {
            if (random.nextDouble() * 100.0 > this.rarity) continue;
            int x = chunkX + random.nextInt(16);
            int z = chunkZ + random.nextInt(16);
            this.spawn(world, random, false, x, z);
        }
    }
}

