/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.generator.resource;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.configuration.BiomeConfig;
import com.khorn.terraincontrol.configuration.ConfigFunction;
import com.khorn.terraincontrol.customobjects.CustomObject;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.generator.resource.Resource;
import com.khorn.terraincontrol.logging.LogMarker;
import com.khorn.terraincontrol.util.ChunkCoordinate;
import com.khorn.terraincontrol.util.Rotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TreeGen
extends Resource {
    private final List<Integer> treeChances;
    private final List<String> treeNames;
    private final List<CustomObject> trees;

    public TreeGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.assureSize(3, args);
        this.frequency = this.readInt(args.get(0), 1, 100);
        this.trees = new ArrayList<CustomObject>();
        this.treeNames = new ArrayList<String>();
        this.treeChances = new ArrayList<Integer>();
        for (int i = 1; i < args.size() - 1; i += 2) {
            CustomObject object = ((BiomeConfig)this.getHolder()).worldConfig.worldObjects.parseCustomObject(args.get(i));
            if (object == null) {
                throw new InvalidConfigException("Custom object " + args.get(i) + " not found!");
            }
            if (!object.canSpawnAsTree()) {
                throw new InvalidConfigException("Custom object " + args.get(i) + " is not a tree!");
            }
            this.trees.add(object);
            this.treeNames.add(args.get(i));
            this.treeChances.add(this.readInt(args.get(i + 1), 1, 100));
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        TreeGen compare = (TreeGen)other;
        return (this.trees == null ? this.trees == compare.trees : this.trees.equals(compare.trees)) && (this.treeNames == null ? this.treeNames == compare.treeNames : this.treeNames.equals(compare.treeNames)) && (this.treeChances == null ? this.treeChances == compare.treeChances : this.treeChances.equals(compare.treeChances));
    }

    @Override
    public int getPriority() {
        return -31;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + super.hashCode();
        hash = 53 * hash + (this.trees != null ? this.trees.hashCode() : 0);
        hash = 53 * hash + (this.treeNames != null ? this.treeNames.hashCode() : 0);
        hash = 53 * hash + (this.treeChances != null ? this.treeChances.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BiomeConfig> other) {
        if (this.getClass() == other.getClass()) {
            try {
                TreeGen otherO = (TreeGen)other;
                return otherO.treeNames.size() == this.treeNames.size() && otherO.treeNames.containsAll(this.treeNames);
            }
            catch (Exception ex) {
                TerrainControl.log(LogMarker.WARN, ex.getMessage(), new Object[0]);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        String output = "Tree(" + this.frequency;
        for (int i = 0; i < this.treeNames.size(); ++i) {
            output = output + "," + this.treeNames.get(i) + "," + this.treeChances.get(i);
        }
        return output + ")";
    }

    @Override
    public void spawn(LocalWorld world, Random random, boolean villageInChunk, int x, int z) {
    }

    @Override
    protected void spawnInChunk(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        for (int i = 0; i < this.frequency; ++i) {
            this.spawnTree(world, random, chunkCoord);
        }
    }

    private void spawnTree(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        for (int treeKind = 0; treeKind < this.trees.size(); ++treeKind) {
            Rotation rotation;
            if (random.nextInt(100) >= this.treeChances.get(treeKind)) continue;
            int x = chunkCoord.getBlockXCenter() + random.nextInt(16);
            int z = chunkCoord.getBlockZCenter() + random.nextInt(16);
            int y = world.getHighestBlockYAt(x, z);
            CustomObject tree = this.trees.get(treeKind);
            if (!tree.canSpawnAt(world, rotation = Rotation.getRandomRotation(random), x, y, z) || !tree.spawnForced(world, random, rotation, x, y, z)) continue;
            return;
        }
    }
}

