/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.util;

import com.khorn.terraincontrol.LocalMaterialData;

public class MaterialSetEntry {
    private final LocalMaterialData material;
    private final boolean includesBlockData;

    public MaterialSetEntry(LocalMaterialData material, boolean includesBlockData) {
        this.material = material;
        this.includesBlockData = includesBlockData;
    }

    public boolean equals(Object other) {
        if (other instanceof MaterialSetEntry) {
            return other.hashCode() == this.hashCode();
        }
        return false;
    }

    public int hashCode() {
        if (this.includesBlockData) {
            return this.material.hashCode();
        }
        return this.material.hashCodeWithoutBlockData();
    }

    public String toString() {
        String output = this.material.toString();
        if (this.includesBlockData && this.material.getBlockData() == 0) {
            return output + ":0";
        }
        return output;
    }

    public MaterialSetEntry rotate() {
        if (!this.includesBlockData) {
            return new MaterialSetEntry(this.material, false);
        }
        return new MaterialSetEntry(this.material.rotate(), true);
    }
}

