/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.util.helpers;

import com.khorn.terraincontrol.TerrainControl;
import com.khorn.terraincontrol.logging.LogMarker;
import java.io.File;
import java.util.Collection;

public final class FileHelper {
    public static boolean makeFolders(Collection<File> folders) {
        boolean allFoldersExist = true;
        for (File directory : folders) {
            if (FileHelper.makeFolder(directory)) continue;
            allFoldersExist = false;
        }
        return allFoldersExist;
    }

    public static boolean makeFolder(File folder) {
        if (!folder.exists() && !folder.mkdirs()) {
            TerrainControl.log(LogMarker.WARN, "Error creating directory \"{}\".", folder.getAbsolutePath());
            return false;
        }
        return true;
    }

    public static boolean migrateFolder(File oldFolder, File newFolder) {
        if (!oldFolder.exists()) {
            return true;
        }
        if (oldFolder.delete()) {
            return true;
        }
        if (newFolder.exists() && !newFolder.delete()) {
            return false;
        }
        return oldFolder.renameTo(newFolder);
    }

    private FileHelper() {
    }
}

