/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.common.capabilities;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.attributestudios.wolfarmor.common.capabilities.IWolfArmor;
import com.attributestudios.wolfarmor.item.ItemWolfArmor;
import com.google.common.base.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityWolfArmor
implements ICapabilitySerializable<NBTTagCompound>,
IWolfArmor,
IInventoryChangedListener {
    @CapabilityInject(value=IWolfArmor.class)
    public static Capability<IWolfArmor> WOLF_ARMOR = null;
    private AnimalChest inventory;
    private static final String NBT_TAG_HAS_CHEST = "hasChest";
    private static final String NBT_TAG_SLOT = "slot";
    private static final String NBT_TAG_INVENTORY = "inventory";
    private static final String NBT_TAG_ARMOR_ITEM = "armorItem";
    private static final int INVENTORY_WOLF_MAX_SIZE = 7;
    private final EntityWolf wolf;
    private final EntityDataManager dataManager;
    private static final DataParameter<Byte> HAS_CHEST = EntityDataManager.func_187226_a(EntityWolf.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Optional<ItemStack>> ARMOR_ITEM = EntityDataManager.func_187226_a(EntityWolf.class, (DataSerializer)DataSerializers.field_187196_f);

    public static boolean getIsValidWolfArmorItem(@Nullable Item item) {
        return item == null || item instanceof ItemWolfArmor;
    }

    public static boolean getIsValidWolfArmorItem(@Nullable ItemStack item) {
        return item == null || CapabilityWolfArmor.getIsValidWolfArmorItem(item.func_77973_b());
    }

    public CapabilityWolfArmor(EntityWolf wolf) {
        this.wolf = wolf;
        this.dataManager = wolf.func_184212_Q();
        this.dataManager.func_187214_a(HAS_CHEST, (Object)0);
        this.dataManager.func_187214_a(ARMOR_ITEM, (Object)Optional.absent());
        this.inventoryInit();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        boolean entityHasChest = this.getHasChest();
        boolean entityHasArmor = this.getHasArmor();
        tags.func_74757_a(NBT_TAG_HAS_CHEST, entityHasChest);
        if (entityHasChest) {
            NBTTagList inventoryItemsTagList = new NBTTagList();
            for (byte slotIndex = 0; slotIndex < this.getInventory().func_70302_i_(); slotIndex = (byte)((byte)(slotIndex + 1))) {
                ItemStack stackInSlot = this.getInventory().func_70301_a((int)slotIndex);
                if (stackInSlot == null) continue;
                NBTTagCompound slotTag = new NBTTagCompound();
                slotTag.func_74774_a(NBT_TAG_SLOT, slotIndex);
                stackInSlot.func_77955_b(slotTag);
                inventoryItemsTagList.func_74742_a((NBTBase)slotTag);
            }
            tags.func_74782_a(NBT_TAG_INVENTORY, (NBTBase)inventoryItemsTagList);
        }
        if (entityHasArmor) {
            ItemStack armorItem = this.getArmorItemStack();
            if (armorItem != null) {
                tags.func_74782_a(NBT_TAG_ARMOR_ITEM, (NBTBase)armorItem.func_77955_b(new NBTTagCompound()));
            } else {
                tags.func_82580_o(NBT_TAG_ARMOR_ITEM);
            }
        }
        return tags;
    }

    public void deserializeNBT(NBTTagCompound tags) {
        NBTTagCompound armorTags;
        boolean entityHasChest = tags.func_150297_b(NBT_TAG_HAS_CHEST, 1) && tags.func_74767_n(NBT_TAG_HAS_CHEST);
        this.setHasChest(entityHasChest);
        if (entityHasChest) {
            this.inventoryInit();
            NBTTagList inventoryItemsTagList = tags.func_150295_c(NBT_TAG_INVENTORY, 10);
            for (int tagIndex = 0; tagIndex < inventoryItemsTagList.func_74745_c(); ++tagIndex) {
                NBTTagCompound itemTag = inventoryItemsTagList.func_150305_b(tagIndex);
                byte slotIndex = itemTag.func_74771_c(NBT_TAG_SLOT);
                if (slotIndex >= this.inventory.func_70302_i_()) continue;
                this.inventory.func_70299_a((int)slotIndex, ItemStack.func_77949_a((NBTTagCompound)itemTag));
            }
        }
        if (!(armorTags = tags.func_74775_l(NBT_TAG_ARMOR_ITEM)).func_82582_d()) {
            ItemStack armorItemStack = ItemStack.func_77949_a((NBTTagCompound)armorTags);
            this.equipArmor(armorItemStack);
        }
    }

    @Override
    public boolean getHasChest() {
        return WolfArmorMod.getConfiguration().getIsWolfChestEnabled() && ((Byte)this.dataManager.func_187225_a(HAS_CHEST) & 2) != 0;
    }

    @Override
    public void setHasChest(boolean value) {
        byte hasChest = (Byte)this.dataManager.func_187225_a(HAS_CHEST);
        if (value) {
            this.dataManager.func_187227_b(HAS_CHEST, (Object)((byte)(hasChest | 2)));
        } else {
            this.dataManager.func_187227_b(HAS_CHEST, (Object)((byte)(hasChest & 0xFFFFFFFD)));
        }
    }

    @Override
    public boolean getHasArmor() {
        return this.getArmorItemStack() != null;
    }

    @Override
    @Nonnull
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public ItemStack getArmorItemStack() {
        Optional itemStackOptional = (Optional)this.dataManager.func_187225_a(ARMOR_ITEM);
        if (itemStackOptional.isPresent()) {
            ItemStack armorItemStack = (ItemStack)itemStackOptional.get();
            if (!CapabilityWolfArmor.getIsValidWolfArmorItem(armorItemStack.func_77973_b()) || armorItemStack.field_77994_a == 0) {
                this.dataManager.func_187227_b(ARMOR_ITEM, (Object)Optional.absent());
                return null;
            }
            return armorItemStack;
        }
        return null;
    }

    private void playEquipSound(@Nullable ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemWolfArmor) {
            ItemWolfArmor armorItem = (ItemWolfArmor)stack.func_77973_b();
            SoundEvent sound = armorItem.getMaterial().getEquipSound();
            this.wolf.func_184185_a(sound, 1.0f, 1.0f);
        }
    }

    @Override
    public void setArmorItemStack(ItemStack armorItemStack) {
        IAttributeInstance armorAttribute;
        ItemStack previousItemStack = this.getArmorItemStack();
        if (armorItemStack != null && (previousItemStack == null || previousItemStack.func_77973_b() != armorItemStack.func_77973_b())) {
            this.playEquipSound(armorItemStack);
        }
        Optional itemStackOptional = Optional.fromNullable((Object)armorItemStack);
        if (CapabilityWolfArmor.getIsValidWolfArmorItem(armorItemStack)) {
            this.dataManager.func_187227_b(ARMOR_ITEM, (Object)itemStackOptional);
        }
        if ((armorAttribute = this.wolf.func_110148_a(SharedMonsterAttributes.field_188791_g)) != null) {
            armorAttribute.func_142049_d();
            if (armorItemStack != null) {
                armorAttribute.func_111121_a(((ItemWolfArmor)armorItemStack.func_77973_b()).getMaterial().armorAttr);
            }
        }
    }

    @Override
    public int getMaxSizeInventory() {
        return 7;
    }

    @Override
    public boolean equipArmor(ItemStack armorItemStack) {
        if (!CapabilityWolfArmor.getIsValidWolfArmorItem(armorItemStack) || this.getHasArmor() && armorItemStack != null) {
            return false;
        }
        this.inventory.func_70299_a(0, armorItemStack);
        return true;
    }

    private void openWolfGui(@Nonnull EntityPlayer player) {
        if (!this.wolf.func_130014_f_().field_72995_K) {
            this.wolf.func_70907_r().func_75270_a(true);
            player.openGui((Object)WolfArmorMod.instance, this.wolf.func_145782_y(), this.wolf.func_130014_f_(), MathHelper.func_76128_c((double)this.wolf.field_70165_t), MathHelper.func_76128_c((double)this.wolf.field_70163_u), MathHelper.func_76128_c((double)this.wolf.field_70161_v));
        }
    }

    @Override
    public boolean processInteract(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, ItemStack stack) {
        if (this.wolf.func_70909_n() && this.wolf.func_152114_e((EntityLivingBase)player) && !this.wolf.func_70631_g_()) {
            if (player.func_70093_af()) {
                this.openWolfGui(player);
                return true;
            }
            if (stack != null) {
                if (WolfArmorMod.getConfiguration().getIsWolfChestEnabled() && Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150486_ae && !this.getHasChest()) {
                    this.setHasChest(true);
                    this.wolf.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.wolf.func_70681_au().nextFloat() - this.wolf.func_70681_au().nextFloat()) * 0.2f + 1.0f);
                    this.inventoryInit();
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    return true;
                }
                if (CapabilityWolfArmor.getIsValidWolfArmorItem(stack)) {
                    this.openWolfGui(player);
                    return true;
                }
            }
        }
        return false;
    }

    private void inventoryInit() {
        AnimalChest inventoryExisting = this.inventory;
        this.inventory = new AnimalChest("container.wolfarmor.wolf", this.getMaxSizeInventory());
        String customName = this.wolf.func_95999_t();
        if (!customName.isEmpty()) {
            this.inventory.func_110133_a(customName);
        }
        if (inventoryExisting != null) {
            inventoryExisting.func_110132_b((IInventoryChangedListener)this);
            int numberOfItemsExisting = Math.min(this.inventory.func_70302_i_(), inventoryExisting.func_70302_i_());
            for (int slotIndex = 0; slotIndex < numberOfItemsExisting; ++slotIndex) {
                ItemStack stackInSlot = inventoryExisting.func_70301_a(slotIndex);
                if (stackInSlot == null) continue;
                this.inventory.func_70299_a(slotIndex, stackInSlot.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.inventory.func_70296_d();
    }

    public void func_76316_a(@Nonnull InventoryBasic invBasic) {
        ItemStack armor = this.inventory.func_70301_a(0);
        this.setArmorItemStack(armor);
    }

    @Override
    public void dropEquipment(boolean killedByPlayer, int lootingModifier) {
        ItemStack armorItem;
        if (this.getHasArmor() && (armorItem = this.getArmorItemStack()) != null) {
            this.wolf.func_70099_a(armorItem, 0.0f);
            this.inventory.func_70299_a(0, null);
        }
        if (this.getHasChest()) {
            this.wolf.func_70099_a(new ItemStack((Block)Blocks.field_150486_ae, 1), 0.0f);
            for (int slotIndex = 1; slotIndex < this.getMaxSizeInventory(); ++slotIndex) {
                ItemStack stack = this.inventory.func_70301_a(slotIndex);
                if (stack == null) continue;
                this.wolf.func_70099_a(stack, 0.0f);
                this.inventory.func_70299_a(slotIndex, null);
            }
        }
    }

    @Override
    public void damageArmor(float damage) {
        ItemStack armorStack;
        if (this.getHasArmor() && (armorStack = this.inventory.func_70301_a(0)) != null && CapabilityWolfArmor.getIsValidWolfArmorItem(armorStack)) {
            armorStack.func_77972_a((int)Math.ceil(damage), (EntityLivingBase)this.wolf);
            if (armorStack.field_77994_a == 0) {
                this.equipArmor(null);
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == WOLF_ARMOR;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == WOLF_ARMOR) {
            return (T)this;
        }
        return null;
    }
}

