/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.event;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.attributestudios.wolfarmor.common.capabilities.CapabilityWolfArmor;
import com.attributestudios.wolfarmor.common.capabilities.IWolfArmor;
import com.attributestudios.wolfarmor.entity.passive.EntityWolfArmored;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WolfArmorEntityEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorld(@Nonnull EntityJoinWorldEvent event) {
        Entity entity;
        World world = event.getWorld();
        if (!world.field_72995_K && (entity = event.getEntity()).getClass() == EntityWolfArmored.class) {
            WolfArmorMod.getLogger().warning("Replacing EntityWolfArmored with new capable wolf");
            EntityWolfArmored entityWolfArmored = (EntityWolfArmored)entity;
            EntityWolf entityWolf = new EntityWolf(world);
            IWolfArmor wolfArmorCapability = (IWolfArmor)entityWolf.getCapability(CapabilityWolfArmor.WOLF_ARMOR, null);
            IInventory wolfInventory = entityWolfArmored.getInventory();
            IInventory capabilityInventory = wolfArmorCapability.getInventory();
            for (int i = 0; i < wolfInventory.func_70302_i_(); ++i) {
                ItemStack stack = wolfInventory.func_70301_a(i);
                capabilityInventory.func_70299_a(i, stack);
            }
            if (entityWolfArmored.getHasArmor()) {
                wolfArmorCapability.setArmorItemStack(entityWolfArmored.getArmorItemStack());
            }
            if (entityWolfArmored.getHasChest()) {
                wolfArmorCapability.setHasChest(true);
            }
            NBTTagCompound compound = new NBTTagCompound();
            entityWolfArmored.func_189511_e(compound);
            entityWolf.func_82149_j((Entity)entityWolfArmored);
            entityWolf.func_70037_a(compound);
            world.func_72838_d((Entity)entityWolf);
            entityWolfArmored.func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity eventObject = (Entity)event.getObject();
        if (eventObject instanceof EntityWolf && !(eventObject instanceof EntityWolfArmored)) {
            event.addCapability(new ResourceLocation("wolfarmor", "wolf_armor"), (ICapabilityProvider)new CapabilityWolfArmor((EntityWolf)eventObject));
        }
    }

    @SubscribeEvent
    public void onWolfHurt(LivingHurtEvent event) {
        IWolfArmor wolfArmor;
        if (event.getEntity() instanceof EntityWolf && (wolfArmor = (IWolfArmor)event.getEntity().getCapability(CapabilityWolfArmor.WOLF_ARMOR, null)) != null) {
            wolfArmor.damageArmor(event.getAmount());
        }
    }

    @SubscribeEvent
    public void onWolfDropItems(LivingDropsEvent event) {
        if (event.getEntity() instanceof EntityWolf) {
            IWolfArmor wolfArmor = (IWolfArmor)event.getEntity().getCapability(CapabilityWolfArmor.WOLF_ARMOR, null);
            DamageSource Source = event.getSource();
            wolfArmor.dropEquipment(Source != null && Source.func_76346_g() instanceof EntityPlayer, event.getLootingLevel());
        }
    }

    @SubscribeEvent
    public void onPlayerInteractWithWolf(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof EntityWolf) {
            IWolfArmor wolfArmor = (IWolfArmor)event.getTarget().getCapability(CapabilityWolfArmor.WOLF_ARMOR, null);
            EntityPlayer player = event.getEntityPlayer();
            EnumHand hand = EnumHand.MAIN_HAND;
            ItemStack stack = player.func_184614_ca();
            if (stack == null && (stack = player.func_184592_cb()) != null) {
                hand = EnumHand.OFF_HAND;
            }
            if (wolfArmor.processInteract(player, hand, stack)) {
                event.setCanceled(true);
            }
        }
    }
}

