/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobPassiveDay;
import gaia.init.GaiaItems;
import gaia.init.Sounds;
import gaia.items.ItemShard;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGaiaDryad
extends EntityMobPassiveDay {
    private static final UUID MODIFIER_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "Attacking speed penalty", -0.05, 0).func_111168_a(false);
    private EntityAIAttackMelee aiMeleeAttack = new EntityAIAttackMelee((EntityCreature)this, EntityAttributes.attackSpeed2, true);
    private EntityAIAvoidEntity aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 20.0f, EntityAttributes.attackSpeed2, EntityAttributes.attackSpeed3);
    private int switchHealth;
    private int axeAttack;
    private byte stamina;
    private byte staminaTimer;
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(EntityGaiaDryad.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityGaiaDryad(World worldIn) {
        super(worldIn);
        this.field_70728_aV = EntityAttributes.experienceValue1;
        this.field_70138_W = 1.0f;
        this.switchHealth = 0;
        this.axeAttack = 0;
        this.stamina = (byte)120;
        this.staminaTimer = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.maxHealth1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(EntityAttributes.followrange);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(EntityAttributes.moveSpeed1);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.attackDamage1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(EntityAttributes.rateArmor1);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        EntityPlayer player;
        ItemStack itemstack;
        if (damage > EntityAttributes.baseDefense1) {
            damage = EntityAttributes.baseDefense1;
        }
        float input = damage;
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer && (itemstack = (player = (EntityPlayer)entity).func_184586_b(this.func_184600_cs())) != null && itemstack.func_77973_b() instanceof ItemAxe) {
            damage = input * 1.5f;
            ++this.axeAttack;
        }
        return super.func_70097_a(source, damage);
    }

    public void func_70653_a(Entity entityIn, float strenght, double xRatio, double zRatio) {
        super.knockBack(entityIn, strenght, xRatio, zRatio, EntityAttributes.knockback1);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 10;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, byte0 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean isAIEnabled() {
        return true;
    }

    @Override
    public void func_70636_d() {
        if (this.func_70090_H()) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
        }
        if (this.func_70026_G()) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 0));
        }
        if (this.func_70027_ad()) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 0));
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 0));
        }
        if (this.func_110143_aJ() < EntityAttributes.maxHealth1 * 0.25f && this.switchHealth == 0) {
            if (this.field_70146_Z.nextInt(4) == 0) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMeleeAttack);
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAvoid);
                this.switchHealth = 1;
            } else {
                this.switchHealth = 1;
            }
        }
        if (this.switchHealth == 1 && this.field_70173_aa % 10 == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (this.func_110143_aJ() > EntityAttributes.maxHealth1 * 0.25f && this.switchHealth == 1) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiMeleeAttack);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAvoid);
            this.switchHealth = 0;
        }
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0) {
            if (this.staminaTimer > 0) {
                this.staminaTimer = 0;
            }
            if (this.stamina > 0) {
                this.stamina = (byte)(this.stamina - 1);
            }
            if (this.stamina <= 0 && !iattributeinstance.func_180374_a(MODIFIER)) {
                iattributeinstance.func_111121_a(MODIFIER);
            }
        } else if (this.stamina < 120) {
            if (this.staminaTimer < 40) {
                this.staminaTimer = (byte)(this.staminaTimer + 1);
            } else {
                this.stamina = (byte)120;
                if (iattributeinstance.func_180374_a(MODIFIER)) {
                    iattributeinstance.func_111124_b(MODIFIER);
                }
            }
        }
        super.func_70636_d();
    }

    protected SoundEvent func_184639_G() {
        return Sounds.assist_say;
    }

    @Override
    protected SoundEvent func_184601_bQ() {
        return Sounds.assist_hurt;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return Sounds.assist_death;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            if (this.field_70146_Z.nextInt(2) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(GaiaItems.FoodRoot, 1);
            }
            if (this.axeAttack >= 4 && this.field_70146_Z.nextInt(2) == 0) {
                this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150364_r), this.field_70146_Z.nextInt(2) + 1);
            }
            int var11 = this.field_70146_Z.nextInt(3) + 1;
            for (int var12 = 0; var12 < var11; ++var12) {
                ItemShard.Drop_Nugget((Entity)this, 0);
            }
            if (GaiaConfig.AdditionalOre) {
                int var13 = this.field_70146_Z.nextInt(3) + 1;
                for (int var14 = 0; var14 < var13; ++var14) {
                    ItemShard.Drop_Nugget((Entity)this, 4);
                }
            }
            if (this.field_70146_Z.nextInt(EntityAttributes.rateraredrop) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                switch (this.field_70146_Z.nextInt(1)) {
                    case 0: {
                        this.func_145779_a(GaiaItems.BoxIron, 1);
                    }
                }
            }
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiMeleeAttack);
        if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            this.setTextureType(1);
        }
        if (this.field_70170_p.field_73012_v.nextInt(10) == 0) {
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(Items.field_151110_aK));
        }
        return livingdata;
    }

    public float func_70047_e() {
        ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.CHEST);
        float f = itemstack == null || itemstack.func_77973_b() != Items.field_151110_aK ? 1.74f : 0.93f;
        return f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
    }

    public int getTextureType() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    public void setTextureType(int par1) {
        this.field_70180_af.func_187227_b(SKIN, (Object)par1);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("MobType")) {
            byte b0 = par1NBTTagCompound.func_74771_c("MobType");
            this.setTextureType(b0);
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74774_a("MobType", (byte)this.getTextureType());
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > 60.0 && super.func_70601_bi();
    }
}

