/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobPassiveDay;
import gaia.init.GaiaItems;
import gaia.init.Sounds;
import gaia.items.ItemShard;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGaiaSatyress
extends EntityMobPassiveDay {
    private EntityAIAttackMelee aiMeleeAttack = new EntityAIAttackMelee((EntityCreature)this, EntityAttributes.attackSpeed1, true);
    private EntityAIAvoidEntity aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 4.0f, EntityAttributes.attackSpeed1, EntityAttributes.attackSpeed3);
    private int fullHealth;
    private int regenerateHealth;

    public EntityGaiaSatyress(World worldIn) {
        super(worldIn);
        this.field_70728_aV = EntityAttributes.experienceValue1;
        this.field_70138_W = 1.0f;
        this.fullHealth = 0;
        this.regenerateHealth = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.maxHealth1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(EntityAttributes.followrange);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(EntityAttributes.moveSpeed1);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.attackDamage1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(EntityAttributes.rateArmor1);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (damage > EntityAttributes.baseDefense1) {
            damage = EntityAttributes.baseDefense1;
        }
        return super.func_70097_a(source, damage);
    }

    public void func_70653_a(Entity entityIn, float strenght, double xRatio, double zRatio) {
        super.knockBack(entityIn, strenght, xRatio, zRatio, EntityAttributes.knockback1);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 10;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, byte0 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean isAIEnabled() {
        return true;
    }

    @Override
    public void func_70636_d() {
        if (this.func_110143_aJ() < EntityAttributes.maxHealth1 * 0.25f && this.fullHealth == 0) {
            ItemStack stacky = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn, 1, 0), (PotionType)PotionTypes.field_185220_C);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, stacky);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMeleeAttack);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAvoid);
            this.fullHealth = 1;
        }
        if (this.fullHealth == 1 && this.field_70173_aa % 10 == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (this.func_110143_aJ() < EntityAttributes.maxHealth1 && this.fullHealth == 1) {
            if (this.regenerateHealth <= 100) {
                ++this.regenerateHealth;
            } else {
                this.func_184185_a(SoundEvents.field_187664_bz, 0.15f, 1.0f);
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 360, 3));
                this.regenerateHealth = 0;
            }
        } else if (this.func_110143_aJ() >= EntityAttributes.maxHealth1 && this.fullHealth == 1) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
            this.func_184589_d(MobEffects.field_76428_l);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAvoid);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiMeleeAttack);
            this.fullHealth = 0;
            this.regenerateHealth = 0;
        }
        super.func_70636_d();
    }

    protected SoundEvent func_184639_G() {
        return Sounds.assist_say;
    }

    @Override
    protected SoundEvent func_184601_bQ() {
        return Sounds.assist_hurt;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return Sounds.assist_death;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            if (this.field_70146_Z.nextInt(2) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(GaiaItems.FoodMeat, 1);
            }
            int var11 = this.field_70146_Z.nextInt(3) + 1;
            for (int var12 = 0; var12 < var11; ++var12) {
                ItemShard.Drop_Nugget((Entity)this, 0);
            }
            if (GaiaConfig.AdditionalOre) {
                int var13 = this.field_70146_Z.nextInt(3) + 1;
                for (int var14 = 0; var14 < var13; ++var14) {
                    ItemShard.Drop_Nugget((Entity)this, 4);
                }
            }
            if (this.field_70146_Z.nextInt(EntityAttributes.rateraredrop) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                switch (this.field_70146_Z.nextInt(1)) {
                    case 0: {
                        this.func_145779_a(GaiaItems.BoxIron, 1);
                    }
                }
            }
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAvoid);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiMeleeAttack);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
        this.func_180483_b(difficulty);
        return livingdata;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > 60.0 && super.func_70601_bi();
    }
}

