/*
 * Decompiled with CFR 0.152.
 */
package gaia.renderer.entity;

import gaia.entity.monster.EntityGaiaCreep;
import gaia.model.ModelGaiaCreep;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderGaiaCreep
extends RenderLiving {
    private static final ResourceLocation armoredCreeperTextures = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
    private static final ResourceLocation texture = new ResourceLocation("grimoireofgaia", "textures/models/Creep.png");
    private ModelBase GaiaCreepModel = new ModelGaiaCreep(2.0f);
    static RenderManager rend = Minecraft.func_71410_x().func_175598_ae();

    public RenderGaiaCreep(float shadowSize) {
        super(rend, (ModelBase)new ModelGaiaCreep(), shadowSize);
        this.func_177094_a(new Charged_Layer(this));
    }

    protected void updateCreepScale(EntityGaiaCreep entity, float par2) {
        float f1 = entity.getCreeperFlashIntensity(par2);
        float f2 = 1.0f + MathHelper.func_76126_a((float)(f1 * 100.0f)) * f1 * 0.01f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        f1 *= f1;
        f1 *= f1;
        float f3 = (1.0f + f1 * 0.4f) * f2;
        float f4 = (1.0f + f1 * 0.1f) / f2;
        GL11.glScalef((float)f3, (float)f4, (float)f3);
    }

    protected int updateCreepColorMultiplier(EntityGaiaCreep entity, float par2, float par3) {
        float f2 = entity.getCreeperFlashIntensity(par3);
        if ((int)(f2 * 10.0f) % 2 == 0) {
            return 0;
        }
        int i = (int)(f2 * 0.2f * 255.0f);
        if (i < 0) {
            i = 0;
        }
        if (i > 255) {
            i = 255;
        }
        int short1 = 255;
        int short2 = 255;
        int short3 = 255;
        return i << 24 | short1 << 16 | short2 << 8 | short3;
    }

    private void setRenderPassModel(ModelBase gaiaCreepModel2) {
    }

    protected int func_77061_b(EntityGaiaCreep entity, int par2, float par3) {
        return -1;
    }

    protected void func_77041_b(EntityLivingBase par1EntityLivingBase, float par2) {
        this.updateCreepScale((EntityGaiaCreep)par1EntityLivingBase, par2);
    }

    protected int func_77030_a(EntityLivingBase par1EntityLivingBase, float par2, float par3) {
        return this.updateCreepColorMultiplier((EntityGaiaCreep)par1EntityLivingBase, par2, par3);
    }

    protected int inheritRenderPass(EntityLivingBase par1EntityLivingBase, int par2, float par3) {
        return this.func_77061_b((EntityGaiaCreep)par1EntityLivingBase, par2, par3);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return texture;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Charged_Layer
    implements LayerRenderer<EntityGaiaCreep> {
        private static final ResourceLocation LIGHTNING_TEXTURE = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
        private final RenderGaiaCreep creeperRenderer;
        private final ModelGaiaCreep creeperModel = new ModelGaiaCreep(2.0f);

        public Charged_Layer(RenderGaiaCreep creeperRendererIn) {
            this.creeperRenderer = creeperRendererIn;
        }

        public void doRenderLayer(EntityGaiaCreep entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (entitylivingbaseIn.getPowered()) {
                boolean flag = entitylivingbaseIn.func_82150_aj();
                GlStateManager.func_179132_a((!flag ? 1 : 0) != 0);
                this.creeperRenderer.func_110776_a(LIGHTNING_TEXTURE);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179096_D();
                float f = (float)entitylivingbaseIn.field_70173_aa + partialTicks;
                GlStateManager.func_179109_b((float)(f * 0.01f), (float)(f * 0.01f), (float)0.0f);
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179147_l();
                float f1 = 0.5f;
                GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                this.creeperModel.func_178686_a(this.creeperRenderer.func_177087_b());
                this.creeperModel.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179096_D();
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179145_e();
                GlStateManager.func_179084_k();
                GlStateManager.func_179132_a((boolean)flag);
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

