/*
 * Decompiled with CFR 0.152.
 */
package gaia.renderer.entity;

import gaia.model.ModelGaiaWitch;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderGaiaWitch
extends RenderLiving {
    private static final ResourceLocation texture = new ResourceLocation("grimoireofgaia", "textures/models/Witch.png");
    static RenderManager rend = Minecraft.func_71410_x().func_175598_ae();

    public RenderGaiaWitch(float shadowSize) {
        super(rend, (ModelBase)new ModelGaiaWitch(), shadowSize);
        this.func_177094_a(LayerGaiaWitchHeldItem.Right(this, ModelGaiaWitch.anchor));
    }

    public void func_82422_c() {
        GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return texture;
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerGaiaWitchHeldItem
    implements LayerRenderer<EntityLivingBase> {
        ModelRenderer limb;
        EntityEquipmentSlot slot;
        private final RenderLiving livingEntityRenderer;

        public LayerGaiaWitchHeldItem(RenderLiving livingEntityRendererIn, ModelRenderer limb, EntityEquipmentSlot slot) {
            this.livingEntityRenderer = livingEntityRendererIn;
            this.limb = limb;
            this.slot = slot;
        }

        public LayerGaiaWitchHeldItem Left(RenderLiving livingEntityRendererIn, ModelRenderer limb) {
            return new LayerGaiaWitchHeldItem(livingEntityRendererIn, limb, EntityEquipmentSlot.OFFHAND);
        }

        public static LayerGaiaWitchHeldItem Right(RenderLiving livingEntityRendererIn, ModelRenderer limb) {
            return new LayerGaiaWitchHeldItem(livingEntityRendererIn, limb, EntityEquipmentSlot.MAINHAND);
        }

        public void func_177141_a(EntityLivingBase living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            ItemStack stack = living.func_184582_a(this.slot);
            if (stack != null) {
                GlStateManager.func_179094_E();
                if (this.livingEntityRenderer.func_177087_b().field_78091_s) {
                    float f = 0.5f;
                    GlStateManager.func_179109_b((float)0.0f, (float)0.625f, (float)0.0f);
                    GlStateManager.func_179114_b((float)-20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                }
                if (this.slot == EntityEquipmentSlot.MAINHAND) {
                    this.renderHeldItem(living, stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, EnumHandSide.RIGHT);
                }
                if (this.slot == EntityEquipmentSlot.OFFHAND) {
                    this.renderHeldItem(living, stack, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, EnumHandSide.LEFT);
                } else {
                    this.renderHeldItem(living, stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, EnumHandSide.RIGHT);
                }
                GlStateManager.func_179121_F();
            }
        }

        public void renderHeldItem(EntityLivingBase living, ItemStack stack, ItemCameraTransforms.TransformType camera, EnumHandSide handSide) {
            if (stack != null) {
                GlStateManager.func_179094_E();
                if (living.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                }
                this.limb.func_78794_c(0.0625f);
                GlStateManager.func_179114_b((float)-40.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)0.15f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                boolean flag = handSide == EnumHandSide.LEFT;
                GlStateManager.func_179109_b((float)((float)(flag ? -1 : 1) / 16.0f), (float)0.125f, (float)-0.625f);
                Minecraft.func_71410_x().func_175597_ag().func_187462_a(living, stack, camera, flag);
                GlStateManager.func_179121_F();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

