/*
 * Decompiled with CFR 0.152.
 */
package gaia.util;

import gaia.Gaia;
import gaia.GaiaConfig;
import gaia.entity.EntityMobMerchant;
import gaia.entity.passive.EntityGaiaNPCCreeperGirl;
import gaia.entity.passive.EntityGaiaNPCEnderGirl;
import gaia.entity.passive.EntityGaiaNPCHolstaurus;
import gaia.entity.passive.EntityGaiaNPCSlimeGirl;
import gaia.entity.passive.EntityGaiaNPCTrader;
import gaia.entity.passive.EntityGaiaNPCWeresheep;
import gaia.init.GaiaEntity;
import gaia.items.ItemGaiaSpawnEgg;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;

public class GaiaICommand
implements ICommand {
    private final List aliases = new ArrayList();
    private static final int PERMISSION_LEVEL = 4;
    public static final int CHUNK_SIZE = 16;

    public GaiaICommand() {
        this.aliases.add("gaia");
        this.aliases.add("Gaia");
        this.aliases.add("gog");
        this.aliases.add("Gog");
    }

    public int compareTo(ICommand arg0) {
        return 0;
    }

    public String func_71517_b() {
        return "gaia";
    }

    public String func_71518_a(ICommandSender sender) {
        return "gaia <text>";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!GaiaConfig.Debug_Commands) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Gaia Developer commands aren't enabled", new Object[0]));
            return;
        }
        World world = sender.func_130014_f_();
        EntityPlayer player = (EntityPlayer)sender.func_174793_f();
        if (world.field_72995_K) {
            System.out.println("Not processing on Client side");
        } else {
            if (args.length == 0) {
                this.failed(sender);
                return;
            }
            if ((args[0].equalsIgnoreCase("spawn") || args[0].equalsIgnoreCase("summon")) && this.spawn_Command(server, sender, world, player, args)) {
                return;
            }
            if (args[0].equalsIgnoreCase("biome")) {
                if (this.biome_Command(server, sender, world, player, args)) {
                    return;
                }
            } else {
                this.failed(sender);
                return;
            }
        }
    }

    public boolean spawn_Command(MinecraftServer server, ICommandSender sender, World world, EntityPlayer player, String[] args) throws CommandException {
        if (args[1].equalsIgnoreCase("npcs") || args[1].equalsIgnoreCase("npc")) {
            this.spawn_npc(world, player);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + "Summoning: npcs", new Object[0]));
            return true;
        }
        if (args[1].equalsIgnoreCase("mobs") || args[1].equalsIgnoreCase("mob")) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + "Summoning: " + TextFormatting.ITALIC + "" + TextFormatting.GRAY + GaiaICommand.spawn_mobs(world, player) + TextFormatting.RESET + TextFormatting.GREEN + " mobs", new Object[0]));
            return true;
        }
        return false;
    }

    private boolean biome_Command(MinecraftServer server, ICommandSender sender, World world, EntityPlayer player, String[] args) throws CommandException {
        if (args[1].equalsIgnoreCase("listing") || args[1].equalsIgnoreCase("list")) {
            this.biome_List(server, sender, world, player, args);
            return true;
        }
        if (GaiaICommand.isInteger(args[1])) {
            this.biome_Debug(server, sender, world, player, args);
            return true;
        }
        return false;
    }

    private void biome_List(MinecraftServer server, ICommandSender sender, World world, EntityPlayer player, String[] args) throws CommandException {
        this.show_dictionaries();
        for (Biome biome : this.getBiomes()) {
            String name = biome.func_185359_l();
            int id = Biome.func_185362_a((Biome)biome);
            Gaia.logger.info(id + ": " + name);
            this.Biome_types(biome);
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + "Biome Listings Printed to Console", new Object[0]));
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    public void biome_Debug(MinecraftServer server, ICommandSender sender, World world, EntityPlayer player, String[] args) throws CommandException {
        String commandy = args[1].toString();
        int BIOME_ID = Integer.parseInt(commandy);
        if (BIOME_ID <= -1 || Biome.func_185357_a((int)BIOME_ID) == null) {
            this.Invalid_Biome(sender);
            return;
        }
        Biome biome = Biome.func_185357_a((int)BIOME_ID);
        String biomeName = biome.func_185359_l();
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + "Transforming Local Biomes to ID of :  " + BIOME_ID + " : " + biomeName, new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GRAY + "You may have to reload your client", new Object[0]));
        this.Biome_types(biome);
        BlockPos posp = player.func_180425_c();
        BlockPos pos = new BlockPos(posp.func_177958_n(), posp.func_177956_o(), posp.func_177952_p());
        int max = 32;
        int start = -(max / 2);
        int start2 = -(max / 2);
        for (start = -(max / 2); start < max; ++start) {
            for (start2 = -(max / 2); start2 < max; ++start2) {
                pos = new BlockPos(posp.func_177958_n() + start, posp.func_177956_o(), posp.func_177952_p() + start2);
                Chunk chunk = world.func_175726_f(pos);
                if (chunk == null) continue;
                BlockPos c = GaiaICommand.getChunkLocationFromWorldLocation(pos.func_177958_n(), 0, pos.func_177952_p());
                int rx = c.func_177958_n();
                int rz = c.func_177952_p();
                byte[] biomeArray = chunk.func_76605_m();
                biomeArray[rz << 4 | rx] = (byte)(BIOME_ID & 0xFF);
                chunk.func_76630_e();
                world.func_72863_F().func_186025_d(chunk.field_76635_g, chunk.field_76647_h);
                world.func_175704_b(pos, pos);
            }
        }
    }

    public void Biome_types(Biome biome) {
        BiomeDictionary.Type[] map = BiomeDictionary.getTypesForBiome((Biome)biome);
        String messege = "Types: ";
        int size = map.length;
        int iterate = 0;
        for (iterate = 0; iterate < size; ++iterate) {
            messege = messege + map[iterate].toString() + ", ";
        }
        Gaia.logger.info(messege);
        Gaia.logger.info(" ");
    }

    public static void get_types(Biome[] biome) {
        for (int i = 0; i < biome.length; ++i) {
            Gaia.logger.info(biome[i].func_185359_l());
        }
    }

    public void show_dictionaries() {
        Biome[] forest = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
        Biome[] sandy = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
        Biome[] mesa = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.MESA);
        Biome[] plains = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS);
        Biome[] swamp = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP);
        Biome[] spooky = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY);
        Biome[] jungle = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
        Biome[] snowy = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY);
        Biome[] mountain = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN);
        Biome[] hill = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.HILLS);
        Biome[] water = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.WATER);
        Biome[] ocean = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
        Biome[] river = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER);
        Biome[] beach = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.BEACH);
        Biome[] hell = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
        Biome[] sky = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.END);
        String s = " type biomes include:";
        Gaia.logger.info("Forest" + s);
        GaiaICommand.get_types(forest);
        Gaia.logger.info("");
        Gaia.logger.info("Sandy" + s);
        GaiaICommand.get_types(sandy);
        Gaia.logger.info("");
        Gaia.logger.info("Mesa" + s);
        GaiaICommand.get_types(mesa);
        Gaia.logger.info("");
        Gaia.logger.info("Plains" + s);
        GaiaICommand.get_types(plains);
        Gaia.logger.info("");
        Gaia.logger.info("Swamp" + s);
        GaiaICommand.get_types(swamp);
        Gaia.logger.info("");
        Gaia.logger.info("Spooky" + s);
        GaiaICommand.get_types(spooky);
        Gaia.logger.info("");
        Gaia.logger.info("Jungle" + s);
        GaiaICommand.get_types(jungle);
        Gaia.logger.info("");
        Gaia.logger.info("Snowy" + s);
        GaiaICommand.get_types(snowy);
        Gaia.logger.info("");
        Gaia.logger.info("Mountain" + s);
        GaiaICommand.get_types(mountain);
        Gaia.logger.info("");
        Gaia.logger.info("Hills" + s);
        GaiaICommand.get_types(hill);
        Gaia.logger.info("");
        Gaia.logger.info("Ocean" + s);
        GaiaICommand.get_types(ocean);
        Gaia.logger.info("");
        Gaia.logger.info("River" + s);
        GaiaICommand.get_types(river);
        Gaia.logger.info("");
        Gaia.logger.info("Beach" + s);
        GaiaICommand.get_types(beach);
        Gaia.logger.info("");
        Gaia.logger.info("Hell" + s);
        GaiaICommand.get_types(hell);
        Gaia.logger.info("");
        Gaia.logger.info("Sky" + s);
        GaiaICommand.get_types(sky);
        Gaia.logger.info("");
    }

    public Iterable<Biome> getBiomes() {
        return Biome.field_185377_q;
    }

    public static BlockPos getChunkLocationFromWorldLocation(int x, int y, int z) {
        return new BlockPos(x & 0xF, y, z & 0xF);
    }

    public static int spawn_mobs(World world, EntityPlayer player) {
        int Max = GaiaEntity.MaxEgg;
        int amount = 0;
        for (int IDs = 0; IDs < Max + 1; ++IDs) {
            if (!ItemGaiaSpawnEgg.idToEgg.containsKey(IDs)) continue;
            ItemGaiaSpawnEgg.spawnCreature(world, IDs, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            ++amount;
        }
        return amount;
    }

    public void spawn_npc(World world, EntityPlayer player) {
        EntityMobMerchant entity = new EntityGaiaNPCCreeperGirl(world);
        this.spawnit((Entity)entity, player);
        entity = new EntityGaiaNPCEnderGirl(world);
        this.spawnit((Entity)entity, player);
        entity = new EntityGaiaNPCHolstaurus(world);
        this.spawnit((Entity)entity, player);
        entity = new EntityGaiaNPCSlimeGirl(world);
        this.spawnit((Entity)entity, player);
        entity = new EntityGaiaNPCTrader(world);
        this.spawnit((Entity)entity, player);
        entity = new EntityGaiaNPCWeresheep(world);
        this.spawnit((Entity)entity, player);
    }

    public void spawnit(Entity entityspawning, EntityPlayer player) {
        entityspawning.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
        player.field_70170_p.func_72838_d(entityspawning);
    }

    public void failed(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Invalid argument try...", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GRAY + "/gaia spawn <npc, mob>", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GRAY + "/gaia biome list", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GRAY + "/gaia biome <Biome ID>", new Object[0]));
    }

    public void Invalid_Biome(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Invalid Biome ID", new Object[0]));
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(4, this.func_71517_b());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return null;
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }
}

