/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.gui;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IImageProvider
extends IDrawableObject {
    default public boolean isURL() {
        return false;
    }

    public ResourceLocation getImage();

    @SideOnly(value=Side.CLIENT)
    public ITextureObject bindTexture();

    @Override
    @SideOnly(value=Side.CLIENT)
    default public void draw(int x, int y, int w, int h, Color4I col) {
        this.bindTexture();
        GuiHelper.drawTexturedRect(x, y, w, h, col.hasColor() ? col : Color4I.WHITE, this.getMinU(), this.getMinV(), this.getMaxU(), this.getMaxV());
    }

    default public double getMinU() {
        return 0.0;
    }

    default public double getMinV() {
        return 0.0;
    }

    default public double getMaxU() {
        return 1.0;
    }

    default public double getMaxV() {
        return 1.0;
    }
}

