/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.ImmutableColor4I;
import com.feed_the_beast.ftbl.lib.config.PropertyBase;
import com.feed_the_beast.ftbl.lib.internal.FTBLibIntegrationInternal;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public final class PropertyList
extends PropertyBase
implements Iterable<IConfigValue> {
    public static final String ID = "list";
    public static final Color4I COLOR = new ImmutableColor4I(-21943);
    private final List<IConfigValue> list = new ArrayList<IConfigValue>();
    private String valueId;

    public PropertyList(String id) {
        this.valueId = id;
    }

    public PropertyList(Collection<IConfigValue> v) {
        this("null");
        this.addAll(v);
    }

    public PropertyList(IConfigValue v0, IConfigValue ... v) {
        this("null");
        this.add(v0);
        this.addAll(v);
    }

    public String func_176610_l() {
        return ID;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.getList();
    }

    public void clear() {
        this.list.clear();
        this.valueId = "null";
    }

    private boolean hasValidId() {
        return !this.valueId.equals("null");
    }

    public void add(IConfigValue v) {
        if (v.isNull()) {
            return;
        }
        if (this.valueId.equals("null")) {
            this.valueId = v.func_176610_l();
            this.list.add(v);
        } else if (v.func_176610_l().equals(this.valueId)) {
            this.list.add(v);
        }
    }

    public void addAll(Collection<IConfigValue> v) {
        for (IConfigValue v1 : v) {
            this.add(v1);
        }
    }

    public void addAll(IConfigValue ... v) {
        for (IConfigValue v1 : v) {
            this.add(v1);
        }
    }

    public Collection<IConfigValue> getList() {
        return this.list;
    }

    public boolean containsValue(@Nullable Object val) {
        if (this.list.isEmpty()) {
            return false;
        }
        for (IConfigValue value : this.list) {
            if (value.getValue() != val) continue;
            return true;
        }
        if (val == null) {
            return false;
        }
        for (IConfigValue value : this.list) {
            Object o = value.getValue();
            if (o == null || !val.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.valueId);
        if (this.valueId.equals("null")) {
            return;
        }
        Collection<IConfigValue> list = this.getList();
        data.writeShort(list.size());
        for (IConfigValue s : list) {
            s.writeData(data);
        }
    }

    @Override
    public void readData(ByteBuf data) {
        this.clear();
        this.valueId = ByteBufUtils.readUTF8String((ByteBuf)data);
        if (this.valueId.equals("null")) {
            return;
        }
        int s = data.readUnsignedShort();
        IConfigValue blank = FTBLibIntegrationInternal.API.getConfigValueFromID(this.valueId);
        while (--s >= 0) {
            IConfigValue v = blank.copy();
            v.readData(data);
            this.add(v);
        }
    }

    @Override
    public String getString() {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < this.list.size(); ++i) {
            builder.append(this.list.get(i).getString());
            if (i == this.list.size() - 1) continue;
            builder.append(',');
            builder.append(' ');
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public boolean getBoolean() {
        return !this.list.isEmpty();
    }

    @Override
    public int getInt() {
        return this.list.size();
    }

    @Override
    public IConfigValue copy() {
        return new PropertyList(this.list);
    }

    @Override
    public Color4I getColor() {
        return COLOR;
    }

    public void func_152753_a(JsonElement json) {
        if (!this.hasValidId()) {
            return;
        }
        this.list.clear();
        JsonArray a = json.getAsJsonArray();
        if (a.size() == 0) {
            return;
        }
        IConfigValue blank = FTBLibIntegrationInternal.API.getConfigValueFromID(this.valueId);
        for (JsonElement e : a) {
            IConfigValue v = blank.copy();
            v.func_152753_a(e);
            this.add(v);
        }
    }

    public JsonElement func_151003_a() {
        JsonArray a = new JsonArray();
        if (this.hasValidId()) {
            this.list.forEach(v -> a.add(v.func_151003_a()));
        }
        return a;
    }

    @Override
    public Iterator<IConfigValue> iterator() {
        return this.list.iterator();
    }
}

