/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.api.gui.IClientActionGui;
import com.feed_the_beast.ftbl.api.gui.IGuiWrapper;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.ImmutableColor4I;
import com.feed_the_beast.ftbl.lib.client.TexturelessRectangle;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiWrapper;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class GuiBase
extends Panel
implements IClientActionGui {
    private static final List<String> TEMP_TEXT_LIST = new ArrayList<String>();
    public static final TexturelessRectangle DEFAULT_BACKGROUND = new TexturelessRectangle(new ImmutableColor4I(-936168653)).setLineColor(new ImmutableColor4I(-4144960)).setRoundEdges(true);
    public static final Color4I DEFAULT_CONTENT_COLOR = new ImmutableColor4I(-4144960);
    public final Minecraft mc = Minecraft.func_71410_x();
    private final FontRenderer font = this.createFont();
    private int mouseX;
    private int mouseY;
    private int mouseWheel;
    private float partialTicks;
    private boolean refreshWidgets;
    private ScaledResolution screen;
    public boolean fixUnicode;

    public GuiBase(int w, int h) {
        super(0, 0, w, h);
    }

    public static void setupDrawing() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
    }

    public final void initGui() {
        this.screen = new ScaledResolution(this.mc);
        if (this.isFullscreen()) {
            this.posX = 0;
            this.posY = 0;
            this.setWidth(this.screen.func_78326_a());
            this.setHeight(this.screen.func_78328_b());
        }
        this.onInit();
        if (!this.isFullscreen()) {
            this.posX = (this.screen.func_78326_a() - this.width) / 2;
            this.posY = (this.screen.func_78328_b() - this.height) / 2;
        }
        this.refreshWidgets();
        this.updateWidgetPositions();
        this.fixUnicode = this.screen.func_78325_e() % 2 == 1;
    }

    public void onInit() {
    }

    public final void closeGui() {
        this.onClosed();
        if (this.mc.field_71439_g == null) {
            this.mc.func_147108_a(null);
        } else {
            this.mc.field_71439_g.func_71053_j();
        }
    }

    public boolean onClosedByKey() {
        return true;
    }

    public void onClosed() {
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    protected FontRenderer createFont() {
        return this.mc.field_71466_p;
    }

    @Override
    public final void refreshWidgets() {
        this.refreshWidgets = true;
    }

    public boolean isFullscreen() {
        return false;
    }

    public final void updateGui(int mx, int my, float pt) {
        this.partialTicks = pt;
        this.mouseX = mx;
        this.mouseY = my;
        this.mouseWheel = Mouse.getDWheel();
        if (this.refreshWidgets) {
            super.refreshWidgets();
            this.refreshWidgets = false;
        }
    }

    @Override
    public final void renderWidget(GuiBase gui) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        this.drawBackground();
        this.renderWidgets();
    }

    public void renderWidgets() {
        super.renderWidget(this);
    }

    public boolean drawDefaultBackground() {
        return true;
    }

    public void drawBackground() {
        this.getIcon(this).draw(this, Color4I.NONE);
    }

    public void drawForeground() {
        this.addMouseOverText(this, TEMP_TEXT_LIST);
        GuiUtils.drawHoveringText(TEMP_TEXT_LIST, (int)this.mouseX, (int)Math.max(this.mouseY, 18), (int)this.screen.func_78326_a(), (int)this.screen.func_78328_b(), (int)0, (FontRenderer)this.font);
        TEMP_TEXT_LIST.clear();
    }

    public GuiScreen getWrapper() {
        return new GuiWrapper(this);
    }

    public final void openGui() {
        this.mc.func_147108_a(this.getWrapper());
    }

    public final FontRenderer getFont() {
        return this.font;
    }

    public final ScaledResolution getScreen() {
        return this.screen;
    }

    public final int getMouseX() {
        return this.mouseX;
    }

    public final int getMouseY() {
        return this.mouseY;
    }

    public final int getMouseWheel() {
        return this.mouseWheel;
    }

    public final float getPartialTicks() {
        return this.partialTicks;
    }

    public final boolean isMouseButtonDown(int button) {
        return Mouse.isButtonDown((int)button);
    }

    public final boolean isKeyDown(int key) {
        return Keyboard.isKeyDown((int)key);
    }

    public void playSoundFX(SoundEvent e, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)e, (float)pitch));
    }

    public boolean isMouseOver(int x, int y, int w, int h) {
        return this.getMouseX() >= x && this.getMouseY() >= y && this.getMouseX() < x + w && this.getMouseY() < y + h;
    }

    public boolean isMouseOver(Widget w) {
        return this.isMouseOver(w.getAX(), w.getAY(), w.width, w.height);
    }

    public Color4I getContentColor() {
        return DEFAULT_CONTENT_COLOR;
    }

    public void drawString(String text, float x, float y, Color4I col) {
        this.getFont().func_175065_a(text, x, y, col.rgba(), false);
    }

    public void drawString(String text, float x, float y) {
        this.drawString(text, x, y, this.getContentColor());
    }

    public void drawCenteredString(String text, float x, float y, Color4I col) {
        GuiHelper.drawCenteredString(this.getFont(), text, x, y, col);
    }

    public void drawCenteredString(String text, float x, float y) {
        this.drawCenteredString(text, x, y, this.getContentColor());
    }

    @Override
    public void onClientDataChanged() {
    }

    public boolean isOpen() {
        return this.mc.field_71462_r instanceof IGuiWrapper && ((IGuiWrapper)this.mc.field_71462_r).getWrappedGui() == this;
    }
}

