/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.gui.EnumDirection;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class Panel
extends Widget {
    public static final int FLAG_ONLY_RENDER_WIDGETS_INSIDE = 1;
    public static final int FLAG_ONLY_INTERACT_WITH_WIDGETS_INSIDE = 2;
    public static final int FLAG_UNICODE_FONT = 4;
    public static final int FLAG_DEFAULTS = 3;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private int scrollX = 0;
    private int scrollY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private int flags = 0;

    public Panel(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public void addFlags(int f) {
        this.flags |= f;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public Collection<Widget> getWidgets() {
        return this.widgets;
    }

    public abstract void addWidgets();

    public void refreshWidgets() {
        this.getWidgets().clear();
        this.addWidgets();
        this.updateWidgetPositions();
    }

    public void add(Widget widget) {
        widget.setParentPanel(this);
        this.getWidgets().add(widget);
        if (widget instanceof Panel) {
            ((Panel)widget).refreshWidgets();
        }
    }

    public void addAll(Widget ... widgets) {
        for (Widget w : widgets) {
            this.add(w);
        }
    }

    public void addAll(Iterable<? extends Widget> list) {
        for (Widget widget : list) {
            this.add(widget);
        }
    }

    public void updateWidgetPositions() {
    }

    public void setScrollX(double scroll, int elementsWidth) {
        if (elementsWidth < this.width) {
            this.setScrollX(0);
        } else {
            this.setScrollX((int)(scroll * (double)(elementsWidth - this.width)));
        }
    }

    public void setScrollY(double scroll, int elementsHeight) {
        if (elementsHeight < this.height) {
            this.setScrollY(0);
        } else {
            this.setScrollY((int)(scroll * (double)(elementsHeight - this.height)));
        }
    }

    protected int alignWidgets(EnumDirection direction) {
        return this.alignWidgets(direction, 0, 0, 0);
    }

    protected int alignWidgets(EnumDirection direction, int pre, int spacing, int post) {
        int i = pre;
        for (Widget widget : this.getWidgets()) {
            if (direction.isVertical()) {
                widget.setY(i);
                i += widget.height + spacing;
                continue;
            }
            widget.setX(i);
            i += widget.width + spacing;
        }
        if (!this.getWidgets().isEmpty()) {
            i -= spacing;
        }
        return i + post;
    }

    @Override
    public int getAX() {
        return super.getAX() + this.offsetX;
    }

    @Override
    public int getAY() {
        return super.getAY() + this.offsetY;
    }

    protected void setOffset(boolean flag) {
        if (flag) {
            this.offsetX = -this.scrollX;
            this.offsetY = -this.scrollY;
        } else {
            this.offsetY = 0;
            this.offsetX = 0;
        }
    }

    public void setScrollX(int scroll) {
        this.scrollX = scroll;
    }

    public void setScrollY(int scroll) {
        this.scrollY = scroll;
    }

    @Override
    public void renderWidget(GuiBase gui) {
        boolean renderInside = this.hasFlag(1);
        boolean useUnicodeFont = this.hasFlag(4);
        boolean unicode = gui.getFont().func_82883_a();
        gui.getFont().func_78264_a(useUnicodeFont);
        int ax = this.getAX();
        int ay = this.getAY();
        if (renderInside) {
            GuiHelper.pushScissor(gui.getScreen(), ax, ay, this.width, this.height);
        }
        this.renderPanelBackground(gui, ax, ay);
        this.setOffset(true);
        for (Widget widget : this.getWidgets()) {
            if (!widget.shouldRender(gui) || renderInside && !widget.collidesWith(ax, ay, this.width, this.height)) continue;
            this.renderWidget(gui, widget, ax, ay, this.width, this.height);
        }
        this.setOffset(false);
        if (renderInside) {
            GuiHelper.popScissor();
        }
        gui.getFont().func_78264_a(unicode);
    }

    protected void renderPanelBackground(GuiBase gui, int ax, int ay) {
    }

    protected void renderWidget(GuiBase gui, Widget widget, int ax, int ay, int w, int h) {
        widget.renderWidget(gui);
    }

    @Override
    public void addMouseOverText(GuiBase gui, List<String> list) {
        if (this.hasFlag(2) && !gui.isMouseOver(this)) {
            return;
        }
        this.setOffset(true);
        for (Widget w : this.getWidgets()) {
            if (!w.isEnabled(gui) || !gui.isMouseOver(w)) continue;
            w.addMouseOverText(gui, list);
        }
        this.setOffset(false);
    }

    @Override
    public void mousePressed(GuiBase gui, IMouseButton button) {
        if (this.hasFlag(2) && !gui.isMouseOver(this)) {
            return;
        }
        this.setOffset(true);
        for (Widget w : this.getWidgets()) {
            if (!w.isEnabled(gui)) continue;
            w.mousePressed(gui, button);
        }
        this.setOffset(false);
    }

    @Override
    public void mouseReleased(GuiBase gui) {
        this.setOffset(true);
        for (Widget w : this.getWidgets()) {
            if (!w.isEnabled(gui)) continue;
            w.mouseReleased(gui);
        }
        this.setOffset(false);
    }

    @Override
    public boolean keyPressed(GuiBase gui, int key, char keyChar) {
        this.setOffset(true);
        for (Widget w : this.getWidgets()) {
            if (!w.isEnabled(gui) || !w.keyPressed(gui, key, keyChar)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }
}

