/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.ImmutableColor4I;
import com.feed_the_beast.ftbl.lib.client.TexturelessRectangle;
import com.feed_the_beast.ftbl.lib.gui.EnumDirection;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.math.MathHelperLM;
import java.util.List;
import net.minecraft.util.math.MathHelper;

public class Slider
extends Widget {
    public static final IDrawableObject DEFAULT_SLIDER = new TexturelessRectangle(new ImmutableColor4I(-1721342362));
    public static final IDrawableObject DEFAULT_BACKGROUND = new TexturelessRectangle(new ImmutableColor4I(-1724697805));
    public final int sliderSize;
    private double value;
    private boolean isGrabbed;
    public IDrawableObject slider = DEFAULT_SLIDER;
    public IDrawableObject background = DEFAULT_BACKGROUND;

    public Slider(int x, int y, int w, int h, int ss) {
        super(x, y, w, h);
        this.sliderSize = ss;
    }

    @Override
    public void mousePressed(GuiBase gui, IMouseButton button) {
        if (gui.isMouseOver(this)) {
            this.setGrabbed(gui, true);
        }
    }

    @Override
    public void addMouseOverText(GuiBase gui, List<String> list) {
        double max;
        double min = this.getDisplayMin();
        if (min < (max = this.getDisplayMax())) {
            String s = "" + (int)MathHelperLM.map(this.value, 0.0, 1.0, min, max);
            String t = this.getTitle(gui);
            list.add(t.isEmpty() ? s : t + ": " + s);
        }
    }

    @Override
    public void renderWidget(GuiBase gui) {
        int ax = this.getAX();
        int ay = this.getAY();
        if (this.isEnabled(gui)) {
            double v;
            double v0 = v = this.getValue(gui);
            if (this.isGrabbed(gui)) {
                if (gui.isMouseButtonDown(0)) {
                    v = this.getDirection().isVertical() ? ((double)gui.getMouseY() - ((double)ay + (double)this.sliderSize / 2.0)) / (double)(this.height - this.sliderSize) : ((double)gui.getMouseX() - ((double)ax + (double)this.sliderSize / 2.0)) / (double)(this.width - this.sliderSize);
                } else {
                    this.setGrabbed(gui, false);
                }
            }
            if (gui.getMouseWheel() != 0 && this.canMouseScroll(gui)) {
                v += gui.getMouseWheel() < 0 ? this.getScrollStep() : -this.getScrollStep();
            }
            if (v0 != (v = MathHelper.func_151237_a((double)v, (double)0.0, (double)1.0))) {
                this.setValue(gui, v);
            }
        }
        this.background.draw(ax, ay, this.width, this.height, Color4I.NONE);
        if (this.getDirection().isVertical()) {
            this.slider.draw(ax, ay + this.getValueI(gui, this.height), this.width, this.sliderSize, Color4I.NONE);
        } else {
            this.slider.draw(ax + this.getValueI(gui, this.width), ay, this.sliderSize, this.height, Color4I.NONE);
        }
    }

    public boolean isGrabbed(GuiBase gui) {
        return this.isGrabbed;
    }

    public void setGrabbed(GuiBase gui, boolean b) {
        this.isGrabbed = b;
    }

    public void onMoved(GuiBase gui) {
    }

    public boolean canMouseScroll(GuiBase gui) {
        return gui.isMouseOver(this);
    }

    public void setValue(GuiBase gui, double v) {
        if (this.value != v) {
            this.value = MathHelper.func_151237_a((double)v, (double)0.0, (double)1.0);
            this.onMoved(gui);
        }
    }

    public double getValue(GuiBase gui) {
        return this.value;
    }

    public int getValueI(GuiBase gui, int max) {
        return (int)(this.getValue(gui) * (double)(max - this.sliderSize));
    }

    public double getScrollStep() {
        return 0.1;
    }

    public EnumDirection getDirection() {
        return EnumDirection.VERTICAL;
    }

    public double getDisplayMin() {
        return 0.0;
    }

    public double getDisplayMax() {
        return 0.0;
    }
}

